package com.atlassian.analytics.client.extractor;

import com.atlassian.analytics.client.serialize.RequestInfo;
import java.util.Map;

public interface PropertyExtractor
{
    /**
     * @return a mapping of all valid properties on the value, prefixed with name + '.'.
     */
    Map<String, Object> extractProperty(String name, Object value);

    boolean isExcluded(String name);

    /**
     * @return the name of this event
     */
    String extractName(Object event);

    /**
     * @return the user to be associated with this event
     */
    String extractUser(Object event, Map<String, Object> properties);

    /**
     * Enrich properties 
     * @return properties to be added to the event
     */
    Map<String, Object> enrichProperties(Object event);

    /**
     * Determine the sub product for this event
     * @return sub product
     */
    String extractSubProduct(Object event, String product);

    /**
     * Get the application access for the logged in user associated with this event.
     * For un-logged in user, empty string "" is returned.
     * At the moment,it only return the proper value for all JIRA events. Other products like Confluence, return empty string.
     * @return comma separated string representing application access, e.g. ",business,,software,"
     */
    String getApplicationAccess();

    /**
     * get requestCorrelationId
     * @return requestCorrelationId
     */
    String extractRequestCorrelationId(RequestInfo request);
}
