package com.atlassian.analytics.client.extractor;

import com.atlassian.analytics.client.serialize.RequestInfo;
import com.atlassian.sal.api.user.UserManager;

import java.util.Collections;
import java.util.Map;

public class DefaultPropertyExtractor implements PropertyExtractor
{
    private final PropertyExtractorHelper helper;
    private final UserManager userManager;

    public DefaultPropertyExtractor(PropertyExtractorHelper helper, UserManager userManager)
    {
        this.helper = helper;
        this.userManager = userManager;
    }

    @Override
    public Map<String, Object> extractProperty(final String name, final Object value)
    {
        return helper.extractProperty(name, value);
    }

    @Override
    public boolean isExcluded(final String name)
    {
        return helper.isExcluded(name);
    }

    @Override
    public String extractName(final Object event)
    {
        return helper.extractName(event);
    }

    @Override
    public String extractUser(final Object event, final Map<String, Object> properties)
    {
        return getRemoteUser();
    }

    @Override
    public Map<String, Object> enrichProperties(final Object event)
    {
        return Collections.emptyMap();
    }

    @Override
    public String extractSubProduct(final Object event, final String product)
    {
        return helper.extractSubProduct(event, product);
    }

    @Override
    public String getApplicationAccess()
    {
        return "";
    }

    private String getRemoteUser()
    {
        return userManager.getRemoteUsername();
    }

    @Override
    public String extractRequestCorrelationId(final RequestInfo request) {
        return helper.extractRequestCorrelationId(request);
    }
}
