package com.atlassian.analytics.client.configuration;

import com.atlassian.analytics.api.annotations.EventName;

/**
 * Published when analytics configuration is updated.
 */
@EventName("analytics.config.changed")
public class AnalyticsConfigChangedEvent
{
    private final AnalyticsConfig.Key key;
    private final String oldValue;
    private final String newValue;

    public AnalyticsConfigChangedEvent(AnalyticsConfig.Key key, String oldValue, String newValue)
    {
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public AnalyticsConfig.Key getKey()
    {
        return key;
    }

    public String getOldValue()
    {
        return oldValue;
    }

    public String getNewValue()
    {
        return newValue;
    }
}
