package com.atlassian.analytics.client.browser;

import org.codehaus.jackson.map.JsonMappingException;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;


@Provider
public class JsonExceptionMapper implements ExceptionMapper<JsonMappingException>
{
    @Override
    public Response toResponse(JsonMappingException ex)
    {
        String errorMessage = "The analytics event passed through is in an invalid format.\nDetailed error message:\n" + ex.getMessage();
        return Response.status(Response.Status.BAD_REQUEST).entity(errorMessage).type("text/plain").build();
    }
}
