package com.atlassian.analytics.client.api.browser;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import javax.xml.bind.annotation.XmlRootElement;
import java.util.Map;

/**
 * Represents an event that can be triggered from the browser (or any other REST client).
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@XmlRootElement
public class BrowserEvent
{
    private final String name;
    private final Map<String, Object> properties;
    private final long clientTime;

    public BrowserEvent(final String name, final Map<String, Object> properties, final long clientTime)
    {
        this.name = name;
        this.properties = properties;
        this.clientTime = clientTime;
    }

    public String getName()
    {
        return name;
    }

    public Map<String, Object> getProperties()
    {
        return properties;
    }

    public long getClientTime()
    {
        return clientTime;
    }
}
