package com.atlassian.analytics.client;


import com.atlassian.sal.api.license.LicenseHandler;
import com.google.common.base.Strings;
import org.apache.commons.lang.StringUtils;

public class ServerIdProvider
{
    private String serverId = "";
    private final LicenseHandler licenseHandler;

    public ServerIdProvider(final LicenseHandler licenseHandler)
    {
        this.licenseHandler = licenseHandler;
    }

    public String getServerId()
    {
        if (StringUtils.isBlank(serverId))
        {
            serverId = Strings.nullToEmpty(licenseHandler.getServerId());
        }
        return serverId;
    }
}
