package com.atlassian.analytics.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTracer 
{
    private static final Logger log = LoggerFactory.getLogger(EventTracer.class);

    public void logEventSourceInfo(Object event)
    {
        StringBuilder callStack = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int output = 0;
        int frame = 0;

        while (frame < stackTrace.length)
        {
            if (stackTrace[frame].getMethodName().equals("publish"))
                break;
            frame++;
        }
        if (frame == stackTrace.length)
            frame = 2;

        for (; frame < stackTrace.length && output < 10; frame++)
        {
            if (output > 0)
                callStack.append(" ");
            callStack.append(stackTrace[frame].toString());
            output++;
        }
        log.debug("Processing event {} from {}", event.getClass(), callStack);
    }
}
