package com.atlassian.analytics.client;

import org.apache.commons.codec.digest.DigestUtils;

/**
 * Centralised utility class for salting and hashing an analytics string.
 */
public class AnalyticsMd5Hasher
{
    private static final String SALT_WORD = "atlassian-analytics";

    public static String md5Hex(String input, String salt)
    {
        return input != null && salt != null ? DigestUtils.md5Hex(salt + input) : null;
    }

    public static String md5Hex(String input)
    {
        return md5Hex(input, SALT_WORD);
    }
}
