package com.atlassian.analytics.api.events.v2;

import java.util.Optional;

/**
 * This interface is compulsory if you want to use the newest api v2.
 * The new api allows for deserializing nested objects and eradicates whitelist.
 * Also it disallows Map which was the purpose of ACPLUG-56.
 *
 * To use this API just create a BEAN you want to publish and just execute:
 * eventPublisher.publish(new RandomEvent());
 * That's it. No whitelist. Fire and forget.
 * Disclaimer: extractor uses getters to extract field values - non-gettable public fields won't be included
 *
 * Quirks? If you want to publish strings you need to use special annotations, <b>or they won't be included</b>:
 * {@link com.atlassian.analytics.api.annotations.v2.Hashed} or {@link com.atlassian.analytics.api.annotations.v2.SecurityPermitted}
 * Please take the responsibility for the data you publish and consult with nearest COPS department.
 * Some other exceptions exist.
 *
 * To understand in full how to use new API please see:
 * - com.atlassian.analytics.client.extractor.nested.FieldExtractorTest for unit tests for extraction
 * - com.atlassian.analytics.client.pipeline.TestAnnotableAnalyticPipeline for integration tests of whole event pipeline
 * 
 * @since 6.2.0
 */
public interface AnalyticsEvent {
    /**
     * When returns empty, then com.atlassian.analytics.client.pipeline.serialize.properties.extractors.v2.NewMetaExtractor#getEventName(Object)
     * will genenerate snake-cased version of class simple name without trailing event.
     *
     * e.g. ThisIsAnEvent to this-is-an
     *
     * Check this test case for example:
     * com.atlassian.analytics.client.pipeline.TestAnnotableAnalyticPipeline#givenNotDefinedEventNameShouldExtractEventNameFromClassName()
     *
     * @return generated event name
     */
    default Optional<String> getEventName() {
        return Optional.empty();
    }
}
