package com.atlassian.analytics.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>Provides the event name for an analytics event.</p>
 *
 * <p>If it is specified on a method, the method will be invoked to determine the name of the event.
 * This provides a way to dynamically calculate the name of the event.</p>
 *
 * <p>Only methods with zero parameters are supported.
 * If there are more than one, the first one that has this annotation from the array returns by
 * {@link Class#getMethods()} will be used.</p>
 *
 * <p>If it is specified on a class, the value will be taken as the name of the event.
 * This provides a quick way to specific a static name for the event.</p>
 *
 * @deprecated This method doesn't work with new BETTER API that you should migrate to: {@link com.atlassian.analytics.api.events.v2.AnalyticsEvent}
 * @since v2.25
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@Deprecated()
public @interface EventName {
    /**
     * Provides the event name for an analytics event.
     */
    String value() default "";
}
