package com.atlassian.analytics.api.services;

/**
 * <p>Services related to the Atlassian Analytics configuration.</p>
 *
 * @since v3.50
 */
public interface AnalyticsConfigService {
    /**
     * Returns whether or not Atlassian Analytics is enabled in the configuration.
     *
     * @since v3.50
     */
    boolean isAnalyticsEnabled();

    /**
     * Returns whether or not we should be collecting analytics, based on if analytics is enabled and the privacy policy
     * banner acknowledged.
     *
     * @since v3.57
     */
    boolean canCollectAnalytics();
}
