package com.atlassian.analytics.api.listener;

/**
 * Event listener service which allows a product to process analytics events.
 *
 * Products can implement their own analytics listeners, which will listen only for analytics events published in application.
 * This may help to improve performance as analytics plugin do not have to listen to all events published in product.
 * For example when you don't want to have such a listener in analytics plugin:
 * <pre>
 *    {@literal @}EventListener
 *     public void onEvent(Object event)
 *     {
 *         // event processing
 *     }
 * </pre>
 */
public interface ProductAnalyticsEventListener
{
    void processEvent(Object event);
}
