package com.atlassian.analytics.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>Marks an event or an event field as being "privacy policy safe" which means it is safe to collect
 * for analytics purposes and should ignore the whitelist. Attributes marked as safe will still be passed
 * through the allowed words dictionary filter; to avoid this, the event attribute needs to be added
 * to the whitelist.</p>
 * <p></p>
 * <p>The default value is "true", but to explicitly mark a class or field as not being safe for analytics,
 * set the value to "false". This will bypass any filtering functionality and exclude the event/attribute.</p>
 * <p></p>
 *
 * @deprecated as of 3.39. Use plugin-level whitelists instead.
 * @since v3.6
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.FIELD})
public @interface PrivacyPolicySafe
{
    /**
     * Describes whether the event/field should be collected for analytics
     */
    boolean value() default true;
}