/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.common;

import com.atlassian.maven.plugins.amps.codegen.prompter.AbstractModulePrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleProperties;
import com.atlassian.plugins.codegen.modules.common.Resource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public abstract class AbstractResourcePrompter<T extends PluginModuleProperties>
extends AbstractModulePrompter<T> {
    public AbstractResourcePrompter(Prompter prompter) {
        super(prompter);
    }

    protected List<Resource> promptForResources() throws PrompterException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        this.promptForResources(resources);
        return resources;
    }

    protected void promptForResources(List<Resource> resources) throws PrompterException {
        if (this.promptForBoolean("Add Resource", "N")) {
            resources.add(this.promptForResource());
            this.promptForResources(resources);
        }
    }

    protected Resource promptForResource() throws PrompterException {
        Resource resource = new Resource();
        this.promptForResourceNameOrPattern(resource);
        resource.setType(this.promptNotBlank("Enter Resource Type", "download"));
        resource.setLocation(this.promptNotBlank("Enter Location (path to resource file)"));
        resource.setParams(this.promptForParams("Add Resource Parameter?"));
        return resource;
    }

    protected void promptForResourceNameOrPattern(Resource resource) throws PrompterException {
        String name = this.prompt("Enter Resource Name (leave blank to use namePattern)");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            resource.setName(name);
        } else {
            String namePattern = this.prompt("Enter Resource Name Pattern");
            if (StringUtils.isNotBlank((CharSequence)namePattern)) {
                resource.setNamePattern(namePattern);
            } else {
                this.promptForResourceNameOrPattern(resource);
            }
        }
    }
}

