/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.jira;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.AbstractModulePrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.jira.ActionProperties;
import com.atlassian.plugins.codegen.modules.jira.View;
import com.atlassian.plugins.codegen.modules.jira.WebworkModuleCreator;
import com.atlassian.plugins.codegen.modules.jira.WebworkProperties;
import com.atlassian.plugins.codegen.util.ClassnameUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@ModuleCreatorClass(value=WebworkModuleCreator.class)
public class WebworkPrompter
extends AbstractModulePrompter<WebworkProperties> {
    public WebworkPrompter(Prompter prompter) {
        super(prompter);
    }

    @Override
    public WebworkProperties promptForBasicProperties(PluginModuleLocation moduleLocation) throws PrompterException {
        this.suppressAdvancedNamePrompt();
        String moduleName = this.promptNotBlank("Enter Plugin Module Name", "My Webwork Module");
        WebworkProperties props = new WebworkProperties(moduleName);
        props.setActions(this.createDefaultAction(props));
        return props;
    }

    private List<ActionProperties> createDefaultAction(WebworkProperties props) {
        ArrayList<ActionProperties> actions = new ArrayList<ActionProperties>();
        String packageName = this.getDefaultBasePackage() + ".jira.webwork";
        String className = ClassnameUtil.removeSpaces((String)props.getModuleName()) + "Action";
        String fqName = ClassnameUtil.fullyQualifiedName((String)packageName, (String)className);
        ActionProperties action = new ActionProperties(fqName);
        action.setAlias(ClassnameUtil.removeSpaces((String)props.getModuleName()));
        String templatePath = "/templates/" + props.getModuleKey() + "/";
        View success = new View("success", templatePath + "success.vm");
        View input = new View("input", templatePath + "input.vm");
        View error = new View("error", templatePath + "error.vm");
        action.addView(success);
        action.addView(input);
        action.addView(error);
        actions.add(action);
        return actions;
    }

    @Override
    public void promptForAdvancedProperties(WebworkProperties props, PluginModuleLocation moduleLocation) throws PrompterException {
        props.setActions(this.promptForActions(props));
    }

    private List<ActionProperties> promptForActions(WebworkProperties props) throws PrompterException {
        ArrayList<ActionProperties> actions = new ArrayList<ActionProperties>();
        String initialPackage = this.getDefaultBasePackage() + ".jira.webwork";
        String templatePathPrefix = "/templates/" + props.getModuleKey() + "/";
        this.promptForAction(actions, initialPackage, templatePathPrefix);
        return actions;
    }

    private void promptForAction(List<ActionProperties> actions, String packageName, String templatePathPrefix) throws PrompterException {
        String className = this.promptJavaClassname("Enter Action Classname", "MyActionClass");
        String newPackageName = this.promptJavaPackagename("Enter Package Name", packageName);
        String fqClass = ClassnameUtil.fullyQualifiedName((String)newPackageName, (String)className);
        String alias = this.promptNotBlank("Enter Alias", className);
        ActionProperties action = new ActionProperties(fqClass);
        action.setAlias(alias);
        action.setViews(this.promptForViews(action, templatePathPrefix + className.toLowerCase() + "/"));
        actions.add(action);
        if (this.promptForBoolean("Add Another Action?", "N")) {
            this.promptForAction(actions, newPackageName, templatePathPrefix);
        }
    }

    private List<View> promptForViews(ActionProperties action, String templatePath) throws PrompterException {
        ArrayList<View> views = new ArrayList<View>();
        this.promptForView(views, templatePath);
        return views;
    }

    private void promptForView(List<View> views, String templatePath) throws PrompterException {
        String viewName = this.promptNotBlank("Enter View Name", "success");
        String pathWithEndSlash = templatePath;
        if (!pathWithEndSlash.endsWith("/")) {
            pathWithEndSlash = pathWithEndSlash + "/";
        }
        String viewPath = this.promptNotBlank("Enter Template Path", pathWithEndSlash + viewName + ".vm");
        View view = new View(viewName, viewPath);
        views.add(view);
        if (this.promptForBoolean("Add Another View?", "N")) {
            this.promptForView(views, FilenameUtils.getFullPath((String)viewPath));
        }
    }
}

