/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.common.web;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.common.web.AbstractWebFragmentPrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.common.Resource;
import com.atlassian.plugins.codegen.modules.common.web.WebResourceModuleCreator;
import com.atlassian.plugins.codegen.modules.common.web.WebResourceProperties;
import com.atlassian.plugins.codegen.modules.common.web.WebResourceTransformation;
import com.atlassian.plugins.codegen.modules.common.web.WebResourceTransformer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@ModuleCreatorClass(value=WebResourceModuleCreator.class)
public class WebResourcePrompter
extends AbstractWebFragmentPrompter<WebResourceProperties> {
    public static final String CUSTOM_CONTEXT = "Custom Context";

    public WebResourcePrompter(Prompter prompter) {
        super(prompter);
    }

    @Override
    public WebResourceProperties promptForBasicProperties(PluginModuleLocation moduleLocation) throws PrompterException {
        String moduleName = this.promptNotBlank("Enter Plugin Module Name", "My Web Resource");
        WebResourceProperties props = new WebResourceProperties(moduleName);
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        resourceList.add(this.promptForResource());
        this.promptForResources(resourceList);
        props.setResources(resourceList);
        this.suppressAdvancedNamePrompt();
        return props;
    }

    @Override
    public void promptForAdvancedProperties(WebResourceProperties props, PluginModuleLocation moduleLocation) throws PrompterException {
        props.setDependencies(this.promptForList("Add Dependency?", "Enter Dependency"));
        props.setContexts(this.promptForContexts(props.knownContexts()));
        props.setTransformations(this.promptForTransformations());
        props.setConditions(this.promptForConditions());
    }

    private List<String> promptForContexts(List<String> knownContexts) throws PrompterException {
        ArrayList<String> contexts = new ArrayList<String>();
        ArrayList<String> mutableValues = new ArrayList<String>(knownContexts);
        this.promptForContext(contexts, mutableValues);
        return contexts;
    }

    private void promptForContext(List<String> contexts, List<String> knownContexts) throws PrompterException {
        if (this.promptForBoolean("Add Web Resource Context?", "N")) {
            String selectedContext;
            String strIndex;
            StringBuilder contextQuery = new StringBuilder("Choose A Context\n");
            ArrayList<String> indexChoices = new ArrayList<String>(knownContexts.size() + 1);
            int index = 1;
            for (String context : knownContexts) {
                strIndex = Integer.toString(index);
                contextQuery.append(strIndex + ": " + context + "\n");
                indexChoices.add(strIndex);
                ++index;
            }
            strIndex = Integer.toString(index);
            contextQuery.append(strIndex + ": " + CUSTOM_CONTEXT + "\n");
            indexChoices.add(strIndex);
            contextQuery.append("Choose a number: ");
            String contextAnswer = this.prompt(contextQuery.toString(), indexChoices, "1");
            int selectedIndex = Integer.parseInt(contextAnswer) - 1;
            if (selectedIndex < indexChoices.size() - 1) {
                selectedContext = knownContexts.get(selectedIndex);
                knownContexts.remove(selectedIndex);
            } else {
                selectedContext = this.promptNotBlank("Enter Context");
            }
            contexts.add(selectedContext);
            this.promptForContext(contexts, knownContexts);
        }
    }

    private List<WebResourceTransformation> promptForTransformations() throws PrompterException {
        ArrayList<WebResourceTransformation> transformations = new ArrayList<WebResourceTransformation>();
        this.promptForTransformation(transformations);
        return transformations;
    }

    private void promptForTransformation(List<WebResourceTransformation> transformations) throws PrompterException {
        if (this.promptForBoolean("Add Web Resource Transformation?", "N")) {
            String extension = this.promptNotBlank("File Extension");
            WebResourceTransformation transformation = new WebResourceTransformation(extension);
            ArrayList transformers = Lists.newArrayList();
            transformers.add(this.promptForTransformerKey());
            this.promptForTransformers(transformers);
            transformation.setTransformers((List)transformers);
            transformations.add(transformation);
            this.promptForTransformation(transformations);
        }
    }

    private void promptForTransformers(List<WebResourceTransformer> transformers) throws PrompterException {
        if (this.promptForBoolean("Add Transformer Key?", "N")) {
            transformers.add(this.promptForTransformerKey());
        }
    }

    private WebResourceTransformer promptForTransformerKey() throws PrompterException {
        WebResourceTransformer transformer = new WebResourceTransformer();
        transformer.setModuleKey(this.promptNotBlank("Transformer Key"));
        return transformer;
    }
}

