/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.common.servlet;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.AbstractModulePrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.common.servlet.ServletFilterModuleCreator;
import com.atlassian.plugins.codegen.modules.common.servlet.ServletFilterProperties;
import com.atlassian.plugins.codegen.util.ClassnameUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@ModuleCreatorClass(value=ServletFilterModuleCreator.class)
public class ServletFilterModulePrompter
extends AbstractModulePrompter<ServletFilterProperties> {
    public ServletFilterModulePrompter(Prompter prompter) {
        super(prompter);
    }

    @Override
    public ServletFilterProperties promptForBasicProperties(PluginModuleLocation moduleLocation) throws PrompterException {
        String className = this.promptJavaClassname("Enter New Classname", "MyServletFilter");
        String packageName = this.promptJavaPackagename("Enter Package Name", this.getDefaultBasePackage() + ".servlet.filter");
        return new ServletFilterProperties(ClassnameUtil.fullyQualifiedName((String)packageName, (String)className));
    }

    @Override
    public void promptForAdvancedProperties(ServletFilterProperties props, PluginModuleLocation moduleLocation) throws PrompterException {
        Map<String, String> initParams;
        props.setUrlPattern(this.getUrlPatternFromUser());
        props.setLocation(this.getLocationFromUser(props.allowedLocations()));
        props.setWeight(this.promptForInt("Location Weight", 100));
        List<String> dispatchers = this.promptForDispatchers(props.allowedDispatchers());
        if (dispatchers.size() > 0) {
            props.setDispatchers(dispatchers);
        }
        if ((initParams = this.promptForInitParams()).size() > 0) {
            props.setInitParams(initParams);
        }
    }

    private String getUrlPatternFromUser() throws PrompterException {
        return this.promptNotBlank("URL Pattern", "/*");
    }

    private String getLocationFromUser(List<String> allowedLocations) throws PrompterException {
        StringBuilder locationQuery = new StringBuilder("Choose Filter Chain Location\n");
        ArrayList<String> indexChoices = new ArrayList<String>(allowedLocations.size());
        int index = 1;
        for (String location : allowedLocations) {
            String strIndex = Integer.toString(index);
            locationQuery.append(strIndex).append(": ").append(location).append("\n");
            indexChoices.add(strIndex);
            ++index;
        }
        locationQuery.append("Choose a number: ");
        String locationAnswer = this.prompt(locationQuery.toString(), indexChoices, "4");
        return allowedLocations.get(Integer.parseInt(locationAnswer) - 1);
    }

    private List<String> promptForDispatchers(List<String> allowedDispatchers) throws PrompterException {
        ArrayList<String> dispatchers = new ArrayList<String>();
        ArrayList<String> mutableValues = new ArrayList<String>(allowedDispatchers);
        this.promptForDispatcher(dispatchers, mutableValues);
        return dispatchers;
    }

    private void promptForDispatcher(List<String> dispatchers, List<String> allowedDispatchers) throws PrompterException {
        boolean addDispatcher = this.promptForBoolean("Add Dispatcher?", "N");
        if (addDispatcher) {
            StringBuilder dispatcherQuery = new StringBuilder("Choose A Dispatcher\n");
            ArrayList<String> indexChoices = new ArrayList<String>(allowedDispatchers.size());
            int index = 1;
            for (String dispatcher : allowedDispatchers) {
                String strIndex = Integer.toString(index);
                dispatcherQuery.append(strIndex).append(": ").append(dispatcher).append("\n");
                indexChoices.add(strIndex);
                ++index;
            }
            dispatcherQuery.append("Choose a number: ");
            String dispatcherAnswer = this.prompt(dispatcherQuery.toString(), indexChoices, "1");
            int selectedIndex = Integer.parseInt(dispatcherAnswer) - 1;
            String selectedDispatcher = allowedDispatchers.get(selectedIndex);
            dispatchers.add(selectedDispatcher);
            allowedDispatchers.remove(selectedIndex);
            this.promptForDispatcher(dispatchers, allowedDispatchers);
        }
    }

    private Map<String, String> promptForInitParams() throws PrompterException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.promptForInitParam(params);
        return params;
    }

    private void promptForInitParam(Map<String, String> params) throws PrompterException {
        StringBuilder addBuffer = new StringBuilder();
        if (params.size() > 0) {
            addBuffer.append("init-params:\n");
            for (Map.Entry<String, String> entry : params.entrySet()) {
                addBuffer.append(entry.getKey()).append("->").append(entry.getValue()).append("\n");
            }
        }
        addBuffer.append("Add Init-Param?");
        boolean addParam = this.promptForBoolean(addBuffer.toString(), "N");
        if (addParam) {
            String key = this.promptNotBlank("param key");
            String value = this.promptNotBlank("param value");
            params.put(key, value);
            this.promptForInitParam(params);
        }
    }
}

