/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter;

import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompter;
import com.atlassian.plugins.codegen.modules.NameBasedModuleProperties;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.PluginModuleProperties;
import com.atlassian.plugins.codegen.util.ClassnameUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public abstract class AbstractModulePrompter<T extends PluginModuleProperties>
implements PluginModulePrompter<T> {
    public static final String DEFAULT_BASE_PACKAGE = "com.example";
    public static final String MODULE_NAME_PROMPT = "Module Name";
    public static final String MODULE_KEY_PROMPT = "Module Key";
    public static final String MODULE_DESCRIP_PROMPT = "Module Description";
    public static final String DEFAULT_PLUGIN_KEY = "example";
    protected final Prompter prompter;
    protected boolean showExamplesPrompt;
    protected boolean showAdvancedPrompt;
    protected boolean showAdvancedNamePrompt;
    protected String defaultBasePackage;
    protected String pluginKey;

    public AbstractModulePrompter(Prompter prompter) {
        this.prompter = prompter;
        this.showExamplesPrompt = true;
        this.showAdvancedPrompt = true;
        this.showAdvancedNamePrompt = true;
    }

    @Override
    public T getModulePropertiesFromInput(PluginModuleLocation moduleLocation) throws PrompterException {
        boolean showAdvanced;
        this.suppressExamplesPrompt();
        T props = this.promptForBasicProperties(moduleLocation);
        if (this.showAdvancedPrompt && (showAdvanced = this.promptForBoolean("Show Advanced Setup?", "N"))) {
            if (props instanceof NameBasedModuleProperties) {
                NameBasedModuleProperties namedProps = (NameBasedModuleProperties)props;
                String moduleName = this.showAdvancedNamePrompt ? this.promptNotBlank(MODULE_NAME_PROMPT, namedProps.getModuleName()) : namedProps.getModuleName();
                String moduleKey = this.promptNotBlank(MODULE_KEY_PROMPT, namedProps.getModuleKey());
                String moduleDescription = this.promptNotBlank(MODULE_DESCRIP_PROMPT, namedProps.getDescription());
                String moduleI18nNameKey = this.promptNotBlank("i18n Name Key", namedProps.getNameI18nKey());
                String moduleI18nDescriptionKey = this.promptNotBlank("i18n Description Key", namedProps.getDescriptionI18nKey());
                namedProps.setModuleName(moduleName);
                namedProps.setModuleKey(moduleKey);
                namedProps.setDescription(moduleDescription);
                namedProps.setNameI18nKey(moduleI18nNameKey);
                namedProps.setDescriptionI18nKey(moduleI18nDescriptionKey);
            }
            this.promptForAdvancedProperties(props, moduleLocation);
        }
        if (this.showExamplesPrompt) {
            props.setIncludeExamples(this.promptForBoolean("Include Example Code?", "N"));
        }
        return props;
    }

    @Override
    public abstract T promptForBasicProperties(PluginModuleLocation var1) throws PrompterException;

    @Override
    public void promptForAdvancedProperties(T props, PluginModuleLocation moduleLocation) throws PrompterException {
    }

    protected String promptJavaClassname(String message) throws PrompterException {
        return this.promptJavaClassname(message, null);
    }

    protected String promptJavaClassname(String message, String defaultValue) throws PrompterException {
        String classname = StringUtils.isBlank((CharSequence)defaultValue) ? this.prompter.prompt(this.requiredMessage(message)) : this.prompt(message, defaultValue);
        if (StringUtils.isBlank((CharSequence)classname) || !ClassnameUtil.isValidClassName((String)classname)) {
            classname = this.promptJavaClassname(message, defaultValue);
        }
        return classname;
    }

    protected String promptJavaPackagename(String message) throws PrompterException {
        return this.promptJavaPackagename(message, null);
    }

    protected String promptFullyQualifiedJavaClass(String message, String defaultValue) throws PrompterException {
        String fqName = StringUtils.isBlank((CharSequence)defaultValue) ? this.prompter.prompt(this.requiredMessage(message)) : this.prompt(message, defaultValue);
        String packageName = "";
        String className = "";
        if (fqName.contains(".")) {
            packageName = StringUtils.substringBeforeLast((String)fqName, (String)".");
            className = StringUtils.substringAfterLast((String)fqName, (String)".");
        } else {
            className = fqName;
        }
        if (StringUtils.isBlank((CharSequence)fqName) || !ClassnameUtil.isValidPackageName((String)packageName) || !ClassnameUtil.isValidClassName((String)className)) {
            fqName = this.promptFullyQualifiedJavaClass(message, defaultValue);
        }
        return fqName;
    }

    protected String promptFullyQualifiedJavaClassBlankOK(String message, String defaultValue) throws PrompterException {
        String fqName = StringUtils.isBlank((CharSequence)defaultValue) ? this.prompter.prompt(message) : this.prompt(message, defaultValue);
        if (StringUtils.isNotBlank((CharSequence)fqName)) {
            String packageName = "";
            String className = "";
            if (fqName.contains(".")) {
                packageName = StringUtils.substringBeforeLast((String)fqName, (String)".");
                className = StringUtils.substringAfterLast((String)fqName, (String)".");
            } else {
                className = fqName;
            }
            if (!ClassnameUtil.isValidPackageName((String)packageName) || !ClassnameUtil.isValidClassName((String)className)) {
                fqName = this.promptFullyQualifiedJavaClass(message, defaultValue);
            }
        }
        return fqName;
    }

    protected String promptJavaPackagename(String message, String defaultValue) throws PrompterException {
        String packagename = StringUtils.isBlank((CharSequence)defaultValue) ? this.prompter.prompt(this.requiredMessage(message)) : this.prompt(message, defaultValue);
        if (StringUtils.isBlank((CharSequence)packagename) || !ClassnameUtil.isValidPackageName((String)packagename)) {
            packagename = this.promptJavaPackagename(message, defaultValue);
        }
        return packagename;
    }

    protected String promptNotBlank(String message) throws PrompterException {
        return this.promptNotBlank(message, null);
    }

    protected String promptNotBlank(String message, String defaultValue) throws PrompterException {
        String value = StringUtils.isBlank((CharSequence)defaultValue) ? this.prompter.prompt(this.requiredMessage(message)) : this.prompt(message, defaultValue);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = this.promptNotBlank(message, defaultValue);
        }
        return value;
    }

    protected boolean promptForBoolean(String message) throws PrompterException {
        return this.promptForBoolean(message, null);
    }

    protected boolean promptForBoolean(String message, String defaultValue) throws PrompterException {
        String answer = StringUtils.isBlank((CharSequence)defaultValue) ? this.prompter.prompt(this.requiredMessage(message), YN_ANSWERS) : this.prompt(message, YN_ANSWERS, defaultValue);
        boolean bool = "y".equals(answer.toLowerCase());
        return bool;
    }

    protected Map<String, String> promptForParams(String message) throws PrompterException {
        HashMap<String, String> params = new HashMap<String, String>();
        this.promptForParam(message, params);
        return params;
    }

    protected void promptForParam(String message, Map<String, String> params) throws PrompterException {
        StringBuilder addBuffer = new StringBuilder();
        if (params.size() > 0) {
            addBuffer.append("params:\n");
            for (Map.Entry<String, String> entry : params.entrySet()) {
                addBuffer.append(entry.getKey()).append("->").append(entry.getValue()).append("\n");
            }
        }
        addBuffer.append(message);
        boolean addParam = this.promptForBoolean(addBuffer.toString(), "N");
        if (addParam) {
            String key = this.promptNotBlank("param name");
            String value = this.promptNotBlank("param value");
            params.put(key, value);
            this.promptForParam(message, params);
        }
    }

    protected List<String> promptForList(String addMessage, String enterMessage) throws PrompterException {
        ArrayList<String> vals = new ArrayList<String>();
        this.promptForListValue(addMessage, enterMessage, vals);
        return vals;
    }

    protected void promptForListValue(String addMessage, String enterMessage, List<String> vals) throws PrompterException {
        StringBuilder addBuffer = new StringBuilder();
        if (vals.size() > 0) {
            addBuffer.append("values:\n");
            for (String val : vals) {
                addBuffer.append(val).append("\n");
            }
        }
        addBuffer.append(addMessage);
        boolean addValue = this.promptForBoolean(addBuffer.toString(), "N");
        if (addValue) {
            String value = this.promptNotBlank(enterMessage);
            vals.add(value);
            this.promptForListValue(addMessage, enterMessage, vals);
        }
    }

    protected int promptForInt(String message, int defaultInt) throws PrompterException {
        String userVal = this.promptNotBlank(message, Integer.toString(defaultInt));
        int userInt = !StringUtils.isNumeric((CharSequence)userVal) ? this.promptForInt(message, defaultInt) : Integer.parseInt(userVal);
        return userInt;
    }

    protected String prompt(String message, String defaultValue) throws PrompterException {
        return this.prompter.prompt(message, defaultValue);
    }

    protected String prompt(String message) throws PrompterException {
        return this.prompter.prompt(message);
    }

    protected String prompt(String message, List possibleValues, String defaultValue) throws PrompterException {
        return this.prompter.prompt(message, possibleValues, defaultValue);
    }

    protected void suppressExamplesPrompt() {
        this.showExamplesPrompt = false;
    }

    protected void suppressAdvancedPrompt() {
        this.showAdvancedPrompt = false;
    }

    protected void suppressAdvancedNamePrompt() {
        this.showAdvancedNamePrompt = false;
    }

    protected String requiredMessage(String message) {
        return MessageUtils.buffer().failure((Object)message).toString();
    }

    @Override
    public void setDefaultBasePackage(String basePackage) {
        if (StringUtils.isNotBlank((CharSequence)basePackage)) {
            this.defaultBasePackage = basePackage;
        }
    }

    @Override
    public String getDefaultBasePackage() {
        if (StringUtils.isNotBlank((CharSequence)this.defaultBasePackage)) {
            return this.defaultBasePackage;
        }
        return DEFAULT_BASE_PACKAGE;
    }

    @Override
    public void setPluginKey(String pluginKey) {
        this.pluginKey = pluginKey;
    }

    @Override
    public String getPluginKey() {
        return this.pluginKey == null ? DEFAULT_PLUGIN_KEY : this.pluginKey;
    }
}

