/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.common.web;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.common.web.AbstractWebFragmentPrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.common.Label;
import com.atlassian.plugins.codegen.modules.common.Tooltip;
import com.atlassian.plugins.codegen.modules.common.web.WebSectionModuleCreator;
import com.atlassian.plugins.codegen.modules.common.web.WebSectionProperties;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@ModuleCreatorClass(value=WebSectionModuleCreator.class)
public class WebSectionPrompter
extends AbstractWebFragmentPrompter<WebSectionProperties> {
    public WebSectionPrompter(Prompter prompter) {
        super(prompter);
    }

    @Override
    public WebSectionProperties promptForBasicProperties(PluginModuleLocation moduleLocation) throws PrompterException {
        String moduleName = this.promptNotBlank("Enter Plugin Module Name", "My Web Section");
        String location = this.promptNotBlank("Enter Location (e.g. system.admin/mynewsection)");
        WebSectionProperties props = new WebSectionProperties(moduleName, location);
        Label label = new Label(props.getModuleKey() + ".label", props.getModuleName());
        props.setLabel(label);
        this.suppressAdvancedNamePrompt();
        return props;
    }

    @Override
    public void promptForAdvancedProperties(WebSectionProperties props, PluginModuleLocation moduleLocation) throws PrompterException {
        props.setWeight(this.promptForInt("Weight", 1000));
        Label label = props.getLabel();
        String labelKey = this.promptNotBlank("Enter Label Key", props.getLabel().getKey());
        String labelValue = this.promptNotBlank("Enter Label Value", props.getLabel().getValue());
        label.setKey(labelKey);
        label.setValue(labelValue);
        props.addI18nProperty(labelKey, labelValue);
        List<String> labelParamVals = this.promptForList("Add Label Param?", "Enter Param Value");
        if (!labelParamVals.isEmpty()) {
            for (String labelVal : labelParamVals) {
                label.addParam(labelVal);
            }
        }
        if (this.promptForBoolean("Add Tooltip?", "N")) {
            String tooltipKey = this.promptNotBlank("Enter Tooltip Key", props.getModuleKey() + ".tooltip");
            String tooltipValue = this.promptNotBlank("Enter Tooltip Value", props.getModuleName() + " Tooltip");
            Tooltip tooltip = new Tooltip(tooltipKey, tooltipValue);
            List<String> tooltipParamVals = this.promptForList("Add Tooltip Param?", "Enter Param Value");
            if (!tooltipParamVals.isEmpty()) {
                for (String tipVal : tooltipParamVals) {
                    tooltip.addParam(tipVal);
                }
            }
            props.setTooltip(tooltip);
            props.addI18nProperty(tooltipKey, tooltipValue);
        }
        props.setResources(this.promptForResources());
        props.setContextProvider(this.promptForContextProvider());
        Map<String, String> moduleParams = this.promptForParams("Add Plugin Module Param?");
        props.setParams(moduleParams);
        props.setConditions(this.promptForConditions());
    }
}

