/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.annotations.asm;

import com.atlassian.plugins.codegen.annotations.asm.AbstractAnnotationParser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class ProductConditionsLocator
extends AbstractAnnotationParser {
    public static final String JIRA_CONDITIONS_PACKAGE = "com.atlassian.jira.plugin.webfragment.conditions";
    protected static final Map<String, String> productConditionsPackages = new HashMap<String, String>();
    private Log log;
    private String productId;
    private Map<String, String> conditionRegistry;

    public ProductConditionsLocator(String productId, Map<String, String> conditionRegistry) {
        this.productId = productId;
        this.conditionRegistry = conditionRegistry;
    }

    public void parse() throws Exception {
        String basePackage = productConditionsPackages.get(this.productId);
        if (StringUtils.isNotBlank((String)basePackage)) {
            this.parse(basePackage, (ClassVisitor)new ConditionClassVisitor());
        }
    }

    public void parse(String basePackage) throws Exception {
        this.parse(basePackage, (ClassVisitor)new ConditionClassVisitor());
    }

    static {
        productConditionsPackages.put("jira", JIRA_CONDITIONS_PACKAGE);
        productConditionsPackages.put("confluence", JIRA_CONDITIONS_PACKAGE);
        productConditionsPackages.put("bamboo", JIRA_CONDITIONS_PACKAGE);
        productConditionsPackages.put("crowd", JIRA_CONDITIONS_PACKAGE);
        productConditionsPackages.put("fecru", JIRA_CONDITIONS_PACKAGE);
        productConditionsPackages.put("refapp", JIRA_CONDITIONS_PACKAGE);
    }

    public class ConditionClassVisitor
    extends EmptyVisitor {
        private String visitedClassname;
        private boolean isWebCondition;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            boolean isAbstract;
            this.visitedClassname = ProductConditionsLocator.normalize((String)name);
            String iface = "com/atlassian/plugin/web/Condition";
            this.isWebCondition = false;
            boolean bl = isAbstract = (access & 0x400) > 0;
            if (!isAbstract) {
                this.isWebCondition = ArrayUtils.contains((Object[])interfaces, (Object)iface);
                if (!this.isWebCondition) {
                    this.isWebCondition = this.superHasInterface(superName, iface);
                }
            }
            if (this.isWebCondition) {
                String simpleName = StringUtils.substringAfterLast((String)this.visitedClassname, (String)".");
                ProductConditionsLocator.this.conditionRegistry.put(simpleName, this.visitedClassname);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean superHasInterface(String superName, String interfaceName) {
            InputStream is;
            boolean hasInterface;
            block5: {
                hasInterface = false;
                if (ProductConditionsLocator.normalize((String)superName).equals("java.lang.Object")) {
                    return hasInterface;
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String path = superName.replace('.', '/');
                is = null;
                try {
                    is = classLoader.getResourceAsStream(path + ".class");
                    if (null == is) break block5;
                    ClassReader classReader = new ClassReader(is);
                    String[] interfaces = classReader.getInterfaces();
                    hasInterface = ArrayUtils.contains((Object[])classReader.getInterfaces(), (Object)interfaceName);
                    if (hasInterface) break block5;
                    hasInterface = this.superHasInterface(classReader.getSuperName(), interfaceName);
                }
                catch (Exception e) {
                    IOUtils.closeQuietly(is);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return hasInterface;
        }

        public AnnotationVisitor visitAnnotation(String annotationName, boolean isVisible) {
            return null;
        }

        public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
            return null;
        }

        public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
            return null;
        }
    }
}

