/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.common.servlet;

import com.atlassian.plugins.codegen.modules.BasicClassModuleProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServletFilterProperties
extends BasicClassModuleProperties {
    public static final String LOCATION = "LOCATION";
    public static final String WEIGHT = "WEIGHT";
    public static final String URL_PATTERN = "URL_PATTERN";
    public static final String DISPATCHERS = "DISPATCHERS";
    public static final String INIT_PARAMS = "INIT_PARAMS";
    private static final List<String> ALLOWED_LOCATIONS = Arrays.asList("after-encoding", "before-login", "before-decoration", "before-dispatch");
    private static final List<String> ALLOWED_DISPATCHERS = Arrays.asList("REQUEST", "INCLUDE", "FORWARD", "ERROR");

    public ServletFilterProperties() {
        this("MyServletFilter");
    }

    public ServletFilterProperties(String fqClassName) {
        super(fqClassName);
        this.put(DISPATCHERS, new ArrayList());
        this.put(INIT_PARAMS, new HashMap());
        this.setUrlPattern("/*");
        this.setLocation(ALLOWED_LOCATIONS.get(3));
        this.setWeight(100);
    }

    public void setLocation(String location) {
        this.setProperty(LOCATION, location);
    }

    public void setWeight(int weight) {
        this.setProperty(WEIGHT, Integer.toString(weight));
    }

    public void setUrlPattern(String pattern) {
        this.setProperty(URL_PATTERN, pattern);
    }

    public void setDispatchers(List<String> dispatchers) {
        this.put(DISPATCHERS, dispatchers);
    }

    public void addDispatcher(String dispatcher) {
        ArrayList<String> dispatchers = (ArrayList<String>)this.get(DISPATCHERS);
        if (dispatchers == null) {
            dispatchers = new ArrayList<String>();
            this.setDispatchers(dispatchers);
        }
        dispatchers.add(dispatcher);
    }

    public void setInitParams(Map<String, String> params) {
        this.put(INIT_PARAMS, params);
    }

    public void addInitParam(String name, String value) {
        HashMap<String, String> params = (HashMap<String, String>)this.get(INIT_PARAMS);
        if (params == null) {
            params = new HashMap<String, String>();
            this.setInitParams(params);
        }
        params.put(name, value);
    }

    public List<String> allowedLocations() {
        return Collections.unmodifiableList(ALLOWED_LOCATIONS);
    }

    public List<String> allowedDispatchers() {
        return Collections.unmodifiableList(ALLOWED_DISPATCHERS);
    }
}

