/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.util;

import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class PluginXmlHelper {
    private final Document document;
    private final File xmlFile;
    private final PluginModuleLocation location;

    public static Option<Element> findElementByTypeAndAttribute(Element parent, String type, String attributeName, String attributeValue) {
        List children = parent.elements(type);
        return Option.fromOptional(children.stream().filter(Element.class::isInstance).map(Element.class::cast).filter(e -> attributeValue.equals(e.attributeValue(attributeName))).findFirst());
    }

    private static Document read(File xmlFile) throws DocumentException, FileNotFoundException {
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
        reader.setMergeAdjacentText(true);
        reader.setStripWhitespaceText(false);
        return reader.read((InputStream)new FileInputStream(xmlFile));
    }

    public PluginXmlHelper(PluginModuleLocation location) throws DocumentException, IOException {
        this(location, "atlassian-plugin.xml");
    }

    @VisibleForTesting
    PluginXmlHelper(PluginModuleLocation location, String descriptorName) throws DocumentException, IOException {
        this.location = location;
        this.xmlFile = new File(location.getResourcesDir(), descriptorName);
        this.document = PluginXmlHelper.read(this.xmlFile);
    }

    public PluginXmlHelper(File pluginXmlFile) throws IOException, DocumentException {
        this.location = null;
        this.xmlFile = pluginXmlFile;
        this.document = PluginXmlHelper.read(pluginXmlFile);
    }

    public Document getDocument() {
        return this.document;
    }

    public File getXmlFile() {
        return this.xmlFile;
    }

    private String getPluginKey() {
        String key = this.document.getRootElement().attributeValue("key");
        if (key == null) {
            throw new IllegalStateException("atlassian-plugin element does not have required attribute: key");
        }
        if (this.location == null) {
            if (key.contains("${")) {
                String message = String.format("cannot substitute placeholders in plugin key '%s' when plugin details are unknown", key);
                throw new UnsupportedOperationException(message);
            }
            return key;
        }
        return key.replace("${project.groupId}", this.location.getGroupId()).replace("${project.artifactId}", this.location.getArtifactId()).replace("${atlassian.plugin.key}", this.location.getDefaultPluginKey());
    }

    public String getDefaultI18nName() {
        return "i18n";
    }

    @Nonnull
    public String getDefaultI18nLocation() {
        List i18nNodes = this.document.selectNodes("//resource[@type='i18n']");
        return i18nNodes.stream().filter(Element.class::isInstance).map(Element.class::cast).findFirst().map(element -> element.attributeValue("location")).orElseGet(this::getPluginKey);
    }
}

