/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.modules.PluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleCreatorRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class PluginModuleCreatorRegistryImpl
implements PluginModuleCreatorRegistry {
    private final Map<String, SortedMap<Class, PluginModuleCreator>> creatorRegistry;

    public PluginModuleCreatorRegistryImpl() {
        ModuleNameComparator comparator = new ModuleNameComparator();
        HashMap registry = new HashMap();
        registry.put("jira", new TreeMap(comparator));
        registry.put("bamboo", new TreeMap(comparator));
        registry.put("bitbucket", new TreeMap(comparator));
        registry.put("confluence", new TreeMap(comparator));
        registry.put("crowd", new TreeMap(comparator));
        registry.put("fecru", new TreeMap(comparator));
        registry.put("refapp", new TreeMap(comparator));
        this.creatorRegistry = Collections.unmodifiableMap(registry);
    }

    public void registerModuleCreator(String productId, PluginModuleCreator moduleCreator) {
        Map moduleMap = this.creatorRegistry.get(productId);
        if (null != moduleMap) {
            moduleMap.put(moduleCreator.getClass(), moduleCreator);
        }
    }

    public <T extends PluginModuleCreator> T getModuleCreator(String productId, Class<T> creatorClass) {
        Map moduleMap = this.creatorRegistry.get(productId);
        PluginModuleCreator creator = null;
        if (null != moduleMap) {
            creator = (PluginModuleCreator)creatorClass.cast(moduleMap.get(creatorClass));
        }
        return (T)creator;
    }

    public Map<Class, PluginModuleCreator> getModuleCreatorsForProduct(String productId) {
        SortedMap<Class, PluginModuleCreator> moduleMap = this.creatorRegistry.get(productId);
        if (null != moduleMap) {
            moduleMap = Collections.unmodifiableSortedMap(moduleMap);
        }
        return moduleMap;
    }

    private class ModuleNameComparator
    implements Comparator<Class> {
        private ModuleNameComparator() {
        }

        @Override
        public int compare(Class class1, Class class2) {
            return class1.getSimpleName().compareTo(class2.getSimpleName());
        }
    }
}

