/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules;

import com.atlassian.plugins.codegen.ClassId;
import com.atlassian.plugins.codegen.I18nString;
import com.atlassian.plugins.codegen.ModuleDescriptor;
import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.ResourceFile;
import com.atlassian.plugins.codegen.SourceFile;
import com.atlassian.plugins.codegen.modules.ClassBasedModuleProperties;
import com.atlassian.plugins.codegen.modules.PluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleProperties;
import com.atlassian.plugins.codegen.modules.common.Resource;
import com.atlassian.plugins.codegen.util.CodeTemplateHelper;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public abstract class AbstractPluginModuleCreator<T extends PluginModuleProperties>
implements PluginModuleCreator<T> {
    public static final String DEFAULT_I18N_NAME = "atlassian-plugin";
    public static final String FUNC_TEST_PACKAGE = "it";
    public static final String UNIT_TEST_PACKAGE = "ut";
    public static final String TEST_SUFFIX = "Test";
    public static final String FUNCT_TEST_SUFFIX = "FuncTest";
    public static final String GENERIC_TEMPLATE_PREFIX = "templates/generic/";
    public static final String GENERIC_TEST_TEMPLATE = "templates/generic/GenericTest.java.vtl";
    public static final String TEMPLATES = "templates/";
    protected CodeTemplateHelper templateHelper;

    protected AbstractPluginModuleCreator() {
        this(new CodeTemplateHelper());
    }

    protected AbstractPluginModuleCreator(CodeTemplateHelper templateHelper) {
        this.templateHelper = templateHelper;
    }

    public abstract PluginProjectChangeset createModule(T var1) throws Exception;

    protected PluginProjectChangeset createClass(ClassBasedModuleProperties props, String templateName) throws Exception {
        return this.createClass(props, props.getClassId(), templateName);
    }

    protected PluginProjectChangeset createClass(ClassBasedModuleProperties props, ClassId classId, String templateName) throws Exception {
        return PluginProjectChangeset.changeset().with(new PluginProjectChange[]{SourceFile.sourceFile((ClassId)classId, (SourceFile.SourceGroup)SourceFile.SourceGroup.MAIN, (String)this.fromTemplate(templateName, (Map<Object, Object>)props.withClass(classId)))});
    }

    protected PluginProjectChangeset createTestClass(ClassBasedModuleProperties props, ClassId classId, String templateName) throws Exception {
        return PluginProjectChangeset.changeset().with(new PluginProjectChange[]{SourceFile.sourceFile((ClassId)classId, (SourceFile.SourceGroup)SourceFile.SourceGroup.TESTS, (String)this.fromTemplate(templateName, (Map<Object, Object>)props.withClass(classId)))});
    }

    protected PluginProjectChangeset createClassAndTests(ClassBasedModuleProperties props, String mainTemplate, String unitTestTemplate) throws Exception {
        ClassId testClass = this.testClassFor(props.getClassId());
        return PluginProjectChangeset.changeset().with(this.createClass(props, mainTemplate)).with(this.createTestClass(props.withClass(testClass), testClass, unitTestTemplate));
    }

    protected PluginProjectChangeset createClassAndTests(ClassBasedModuleProperties props, String mainTemplate, String unitTestTemplate, String funcTestTemplate) throws Exception {
        ClassId funcTestClass = this.funcTestClassFor(props.getClassId());
        return this.createClassAndTests(props, mainTemplate, unitTestTemplate).with(this.createTestClass(props.withClass(funcTestClass), funcTestClass, funcTestTemplate));
    }

    protected PluginProjectChangeset createModule(PluginModuleProperties props, String templateName) throws Exception {
        return PluginProjectChangeset.changeset().with(new PluginProjectChange[]{ModuleDescriptor.moduleDescriptor((String)this.fromTemplate(templateName, (Map<Object, Object>)props))}).with(I18nString.i18nStrings((Map)props.getI18nProperties()));
    }

    protected PluginProjectChangeset createResource(Map<Object, Object> props, String path, String fileName, String templateName) throws Exception {
        return PluginProjectChangeset.changeset().with(new PluginProjectChange[]{ResourceFile.resourceFile((String)path, (String)fileName, (String)this.fromTemplate(templateName, props))});
    }

    protected PluginProjectChangeset createTemplateResource(Map<Object, Object> props, String path, String fileName, String templateName) throws Exception {
        path = path.equals("") ? TEMPLATES : (path.startsWith(TEMPLATES) ? path : TEMPLATES + path);
        return PluginProjectChangeset.changeset().with(new PluginProjectChange[]{ResourceFile.resourceFile((String)path, (String)fileName, (String)this.fromTemplate(templateName, props))});
    }

    protected PluginProjectChangeset createTemplateResource(Map<Object, Object> props, Resource resource, String templateName) throws Exception {
        String resourceFullPath = FilenameUtils.separatorsToSystem((String)resource.getLocation());
        String path = FilenameUtils.getPath((String)resourceFullPath);
        String fileName = FilenameUtils.getName((String)resourceFullPath);
        ImmutableMap tempProps = ImmutableMap.builder().putAll(props).put((Object)"CURRENT_VIEW", (Object)fileName).build();
        return this.createTemplateResource((Map<Object, Object>)tempProps, path, fileName, templateName);
    }

    protected PluginProjectChangeset createI18nStrings(Map<Object, Object> props, String templateName) throws Exception {
        String propListString = this.fromTemplate(templateName, props);
        Properties propList = new Properties();
        propList.load(new StringReader(propListString));
        return PluginProjectChangeset.changeset().with(I18nString.i18nStrings(new TreeMap<Object, Object>(propList)));
    }

    protected String fromTemplate(String templatePath, Map<Object, Object> props) throws Exception {
        return this.templateHelper.getStringFromTemplate(templatePath, props);
    }

    protected String fromFile(String filePath) throws Exception {
        return IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(filePath));
    }

    protected ClassId testClassFor(ClassId mainClass) {
        return mainClass.packageNamePrefix(UNIT_TEST_PACKAGE).classNameSuffix(TEST_SUFFIX);
    }

    protected ClassId funcTestClassFor(ClassId mainClass) {
        return mainClass.packageNamePrefix(FUNC_TEST_PACKAGE).classNameSuffix(FUNCT_TEST_SUFFIX);
    }
}

