/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.annotations.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public abstract class AbstractAnnotationParser {
    public void parse(String basePackage, ClassVisitor classVisitor) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = basePackage.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList dirs = new ArrayList();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            this.processResource(resource, basePackage, classVisitor);
        }
    }

    protected void processResource(URL resource, String packageName, ClassVisitor classVisitor) throws IOException {
        if (resource.getProtocol().equals("file")) {
            this.processFileDirectory(new File(resource.getFile()), packageName, classVisitor);
        } else if (resource.getProtocol().equals("jar")) {
            JarURLConnection conn = (JarURLConnection)resource.openConnection();
            this.processJarDirectory(conn.getJarFile(), packageName, classVisitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJarDirectory(JarFile jarFile, String packageName, ClassVisitor classVisitor) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        String basePath = packageName.replace('.', '/');
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(basePath) || entry.isDirectory() || !name.endsWith(".class")) continue;
            InputStream is = jarFile.getInputStream(entry);
            try {
                this.processClassFile(is, classVisitor);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFileDirectory(File directory, String packageName, ClassVisitor classVisitor) throws IOException {
        File[] files;
        if (!directory.exists()) {
            return;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                this.processFileDirectory(file, packageName + "." + file.getName(), classVisitor);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            FileInputStream is = FileUtils.openInputStream((File)file);
            try {
                this.processClassFile(is, classVisitor);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    protected void processClassFile(InputStream is, ClassVisitor classVisitor) throws IOException {
        ClassReader classReader = new ClassReader(is);
        classReader.accept(classVisitor, 7);
    }

    protected static String normalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        return name.replace('/', '.');
    }
}

