/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.plugins.codegen.modules.BasicClassModuleProperties;
import com.atlassian.plugins.codegen.modules.common.Resource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CustomFieldProperties
extends BasicClassModuleProperties {
    public static final String RESOURCES = "RESOURCES";
    public static final String CLASS_TO_EXTEND = "CLASS_TO_EXTEND";
    public static final String PACKAGE_TO_EXTEND = "PACKAGE_TO_EXTEND";
    public static final String FQ_CLASS_TO_EXTEND = "FQ_CLASS_TO_EXTEND";

    public CustomFieldProperties() {
        this("MyCustomField");
    }

    public CustomFieldProperties(String fqClassName) {
        super(fqClassName);
        this.setResources(new ArrayList<Resource>());
        this.setFullyQualifiedClassToExtend("com.atlassian.jira.issue.customfields.impl.TextCFType");
    }

    public void setResources(List<Resource> resources) {
        this.put(RESOURCES, resources);
    }

    public List<Resource> getResources() {
        return (List)this.get(RESOURCES);
    }

    public void addResource(Resource resource) {
        List<Resource> resources = this.getResources();
        if (null == resources) {
            resources = new ArrayList<Resource>();
            this.setResources(resources);
        }
        resources.add(resource);
    }

    public void setFullyQualifiedClassToExtend(String fqName) {
        if (StringUtils.isNotBlank((String)fqName)) {
            if (fqName.lastIndexOf(".") > 0) {
                String classname = StringUtils.substringAfterLast((String)fqName, (String)".");
                String packageName = StringUtils.substringBeforeLast((String)fqName, (String)".");
                this.setProperty(CLASS_TO_EXTEND, classname);
                this.setProperty(PACKAGE_TO_EXTEND, packageName);
            } else {
                String classname = fqName;
                this.setProperty(CLASS_TO_EXTEND, classname);
                this.setProperty(PACKAGE_TO_EXTEND, "");
            }
            this.setProperty(FQ_CLASS_TO_EXTEND, fqName);
        }
    }

    public String getFullyQualifiedClassToExtend() {
        return this.getProperty(FQ_CLASS_TO_EXTEND);
    }
}

