/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.plugins.codegen.annotations.Dependencies;
import com.atlassian.plugins.codegen.annotations.Dependency;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.jira.WorkflowElementProperties;
import java.io.File;

@JiraPluginModuleCreator
@Dependencies(value={@Dependency(groupId="org.mockito", artifactId="mockito-all", version="1.8.5", scope="test"), @Dependency(groupId="org.apache.httpcomponents", artifactId="httpclient", version="4.1.1", scope="test")})
public class WorkflowValidatorModuleCreator
extends AbstractPluginModuleCreator<WorkflowElementProperties> {
    public static final String MODULE_NAME = "Workflow Validator";
    private static final String TEMPLATE_PREFIX = "templates/jira/workflow/validator/";
    private static final String FACTORY_TEMPLATE = "templates/jira/workflow/validator/WorkflowValidatorFactory.java.vtl";
    private static final String CLASS_TEMPLATE = "templates/jira/workflow/validator/WorkflowValidator.java.vtl";
    private static final String UNIT_TEST_TEMPLATE = "templates/jira/workflow/validator/WorkflowValidatorTest.java.vtl";
    private static final String FUNC_TEST_TEMPLATE = "templates/jira/workflow/validator/WorkflowValidatorFuncTest.java.vtl";
    private static final String VIEW_TEMPLATE = "templates/jira/workflow/validator/workflow-validator.vm.vtl";
    private static final String INPUT_TEMPLATE = "templates/jira/workflow/validator/workflow-validator-input.vm.vtl";
    private static final String EXAMPLE_CLASS_TEMPLATE = "templates/jira/workflow/validator/Exampletemplates/jira/workflow/validator/WorkflowValidator.java.vtl";
    private static final String PLUGIN_MODULE_TEMPLATE = "templates/jira/workflow/validator/workflow-validator-plugin.xml.vtl";

    @Override
    public void createModule(PluginModuleLocation location, WorkflowElementProperties props) throws Exception {
        String moduleKey = props.getModuleKey();
        String viewFileName = moduleKey + ".vm";
        String inputFileName = moduleKey + "-input.vm";
        String packageName = props.getPackage();
        String functionClass = props.getClassname();
        String factoryClass = props.getFactoryName();
        File templatesDir = new File(location.getTemplateDirectory(), "validators");
        if (!props.includeExamples()) {
            this.templateHelper.writeJavaClassFromTemplate(CLASS_TEMPLATE, functionClass, location.getSourceDirectory(), packageName, props);
            this.templateHelper.writeJavaClassFromTemplate(FACTORY_TEMPLATE, factoryClass, location.getSourceDirectory(), packageName, props);
            this.templateHelper.writeJavaClassFromTemplate(UNIT_TEST_TEMPLATE, this.testClassname(functionClass), location.getTestDirectory(), packageName, props);
            this.templateHelper.writeFileFromTemplate(VIEW_TEMPLATE, viewFileName, templatesDir, props);
            this.templateHelper.writeFileFromTemplate(INPUT_TEMPLATE, inputFileName, templatesDir, props);
        }
        this.addModuleToPluginXml(PLUGIN_MODULE_TEMPLATE, location, props);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

