/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.common.web;

import com.atlassian.plugins.codegen.modules.common.Icon;
import com.atlassian.plugins.codegen.modules.common.Label;
import com.atlassian.plugins.codegen.modules.common.Link;
import com.atlassian.plugins.codegen.modules.common.Tooltip;
import com.atlassian.plugins.codegen.modules.common.web.AbstractWebFragmentProperties;
import java.util.HashMap;
import java.util.Map;

public class WebItemProperties
extends AbstractWebFragmentProperties {
    public static final String SECTION = "SECTION";
    public static final String ICON = "ICON";
    public static final String LINK = "LINK";
    public static final String LABEL = "LABEL";
    public static final String PARAMS = "PARAMS";
    public static final String TOOLTIP = "TOOLTIP";

    public WebItemProperties() {
        this("My Web Item");
    }

    public WebItemProperties(String moduleName) {
        super(moduleName);
        this.setParams(new HashMap<String, String>());
    }

    public WebItemProperties(String moduleName, String section) {
        this(moduleName);
        this.setSection(section);
    }

    public void setSection(String section) {
        this.setProperty(SECTION, section);
    }

    public String getSection() {
        return this.getProperty(SECTION);
    }

    public void setLink(Link link) {
        this.put(LINK, link);
    }

    public Link getLink() {
        Link link = null;
        if (this.keySet().contains(LINK)) {
            link = (Link)this.get(LINK);
        }
        return link;
    }

    public void setIcon(Icon icon) {
        this.put(ICON, icon);
    }

    public Icon getIcon() {
        Icon icon = null;
        if (this.keySet().contains(ICON)) {
            icon = (Icon)this.get(ICON);
        }
        return icon;
    }

    public void setLabel(Label label) {
        this.put(LABEL, label);
        this.addI18nProperty(label.getKey(), label.getValue());
    }

    public Label getLabel() {
        Label label = null;
        if (this.keySet().contains(LABEL)) {
            label = (Label)this.get(LABEL);
        }
        return label;
    }

    public void setTooltip(Tooltip tooltip) {
        this.put(TOOLTIP, tooltip);
        this.addI18nProperty(tooltip.getKey(), tooltip.getValue());
    }

    public Tooltip getTooltip() {
        Tooltip tooltip = null;
        if (this.keySet().contains(TOOLTIP)) {
            tooltip = (Tooltip)this.get(TOOLTIP);
        }
        return tooltip;
    }

    public void setParams(Map<String, String> params) {
        this.put(PARAMS, params);
    }

    public void addParam(String name, String value) {
        ((Map)this.get(PARAMS)).put(name, value);
    }
}

