/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.annotations.asm;

import com.atlassian.plugins.codegen.annotations.BambooPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.ConfluencePluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.CrowdPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.Dependencies;
import com.atlassian.plugins.codegen.annotations.Dependency;
import com.atlassian.plugins.codegen.annotations.DependencyDescriptor;
import com.atlassian.plugins.codegen.annotations.FeCruPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.RefAppPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.asm.AbstractAnnotationParser;
import com.atlassian.plugins.codegen.modules.PluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleCreatorRegistry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class ModuleCreatorAnnotationParser
extends AbstractAnnotationParser {
    public static final String MODULE_PACKAGE = "com.atlassian.plugins.codegen.modules";
    protected static final Map<String, String> annotationProductMap = new HashMap<String, String>();
    private final PluginModuleCreatorRegistry pluginModuleCreatorRegistry;

    public ModuleCreatorAnnotationParser(PluginModuleCreatorRegistry pluginModuleCreatorRegistry) {
        this.pluginModuleCreatorRegistry = pluginModuleCreatorRegistry;
    }

    public void parse() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.parse(MODULE_PACKAGE, (ClassVisitor)new ModuleClassVisitor());
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void parse(String basePackage) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.parse(basePackage, (ClassVisitor)new ModuleClassVisitor());
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    static {
        annotationProductMap.put(JiraPluginModuleCreator.class.getName(), "jira");
        annotationProductMap.put(ConfluencePluginModuleCreator.class.getName(), "confluence");
        annotationProductMap.put(BambooPluginModuleCreator.class.getName(), "bamboo");
        annotationProductMap.put(CrowdPluginModuleCreator.class.getName(), "crowd");
        annotationProductMap.put(FeCruPluginModuleCreator.class.getName(), "fecru");
        annotationProductMap.put(RefAppPluginModuleCreator.class.getName(), "refapp");
    }

    public class ModuleClassVisitor
    extends EmptyVisitor {
        private String visitedClassname;
        private boolean isModuleCreator;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.visitedClassname = AbstractAnnotationParser.normalize(name);
            String iface = PluginModuleCreator.class.getName().replace('.', '/');
            this.isModuleCreator = ArrayUtils.contains((Object[])interfaces, (Object)iface);
            if (!this.isModuleCreator) {
                this.isModuleCreator = this.superHasInterface(superName, iface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean superHasInterface(String superName, String interfaceName) {
            InputStream is;
            boolean hasInterface;
            block5: {
                hasInterface = false;
                if (AbstractAnnotationParser.normalize(superName).equals("java.lang.Object")) {
                    return hasInterface;
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String path = superName.replace('.', '/');
                is = null;
                try {
                    ClassReader classReader;
                    is = classLoader.getResourceAsStream(path + ".class");
                    if (null == is || (hasInterface = ArrayUtils.contains((Object[])(classReader = new ClassReader(is)).getInterfaces(), (Object)interfaceName))) break block5;
                    hasInterface = this.superHasInterface(classReader.getSuperName(), interfaceName);
                }
                catch (Exception e) {
                    IOUtils.closeQuietly(is);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return hasInterface;
        }

        public AnnotationVisitor visitAnnotation(String annotationName, boolean isVisible) {
            String normalizedName = AbstractAnnotationParser.normalize(annotationName);
            if (this.isModuleCreator && annotationProductMap.containsKey(normalizedName)) {
                return new ProductCreatorAnnotationVisitor(normalizedName);
            }
            if (this.isModuleCreator && (Dependencies.class.getName().equals(normalizedName) || Dependency.class.equals((Object)normalizedName))) {
                return new DependenciesAnnotationVisitor(normalizedName);
            }
            return null;
        }

        public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
            return null;
        }

        public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
            return null;
        }

        private class DependencyAnnotationVisitor
        extends EmptyVisitor {
            private String annotationName;
            private List<DependencyDescriptor> dependencies;
            private DependencyDescriptor descriptor;

            private DependencyAnnotationVisitor(String annotationName, List<DependencyDescriptor> dependencies) {
                this.annotationName = annotationName;
                this.dependencies = dependencies;
                this.descriptor = new DependencyDescriptor();
            }

            public void visit(String name, Object value) {
                if (name.equals("groupId")) {
                    this.descriptor.setGroupId((String)value);
                } else if (name.equals("artifactId")) {
                    this.descriptor.setArtifactId((String)value);
                } else if (name.equals("version")) {
                    this.descriptor.setVersion((String)value);
                } else if (name.equals("scope")) {
                    this.descriptor.setScope((String)value);
                }
            }

            public void visitEnd() {
                super.visitEnd();
                this.dependencies.add(this.descriptor);
            }
        }

        private class DependenciesAnnotationVisitor
        extends EmptyVisitor {
            private String annotationName;
            private List<DependencyDescriptor> dependencies;

            private DependenciesAnnotationVisitor(String annotationName) {
                this.annotationName = annotationName;
                this.dependencies = new ArrayList<DependencyDescriptor>();
            }

            public AnnotationVisitor visitAnnotation(String name, String annotationName) {
                String normalizedName = AbstractAnnotationParser.normalize(annotationName);
                return new DependencyAnnotationVisitor(normalizedName, this.dependencies);
            }

            public void visitEnd() {
                super.visitEnd();
                if (!this.dependencies.isEmpty()) {
                    try {
                        Class<?> creatorClass = Class.forName(ModuleClassVisitor.this.visitedClassname);
                        ModuleCreatorAnnotationParser.this.pluginModuleCreatorRegistry.registerModuleCreatorDependencies(creatorClass, this.dependencies);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private class ProductCreatorAnnotationVisitor
        extends EmptyVisitor {
            private String annotationName;

            private ProductCreatorAnnotationVisitor(String annotationName) {
                this.annotationName = annotationName;
            }

            public void visitEnd() {
                super.visitEnd();
                String productId = annotationProductMap.get(this.annotationName);
                if (StringUtils.isNotBlank((String)productId)) {
                    try {
                        PluginModuleCreator creator = (PluginModuleCreator)Class.forName(ModuleClassVisitor.this.visitedClassname).newInstance();
                        ModuleCreatorAnnotationParser.this.pluginModuleCreatorRegistry.registerModuleCreator(productId, creator);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

