/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.plugins.codegen.annotations.Dependencies;
import com.atlassian.plugins.codegen.annotations.Dependency;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.jira.WorkflowElementProperties;
import java.io.File;

@JiraPluginModuleCreator
@Dependencies(value={@Dependency(groupId="org.mockito", artifactId="mockito-all", version="1.8.5", scope="test")})
public class WorkflowConditionModuleCreator
extends AbstractPluginModuleCreator<WorkflowElementProperties> {
    public static final String MODULE_NAME = "Workflow Condition";
    private static final String TEMPLATE_PREFIX = "templates/jira/workflow/condition/";
    private static final String CLASS_TEMPLATE = "templates/jira/workflow/condition/WorkflowCondition.java.vtl";
    private static final String FACTORY_TEMPLATE = "templates/jira/workflow/condition/WorkflowConditionFactory.java.vtl";
    private static final String UNIT_TEST_TEMPLATE = "templates/jira/workflow/condition/WorkflowConditionTest.java.vtl";
    private static final String FUNC_TEST_TEMPLATE = "templates/jira/workflow/condition/WorkflowConditionFuncTest.java.vtl";
    private static final String VIEW_TEMPLATE = "templates/jira/workflow/condition/workflow-condition.vm.vtl";
    private static final String INPUT_TEMPLATE = "templates/jira/workflow/condition/workflow-condition-input.vm.vtl";
    private static final String EXAMPLE_CLASS_TEMPLATE = "templates/jira/workflow/condition/Exampletemplates/jira/workflow/condition/WorkflowCondition.java.vtl";
    private static final String PLUGIN_MODULE_TEMPLATE = "templates/jira/workflow/condition/workflow-condition-plugin.xml.vtl";

    @Override
    public void createModule(PluginModuleLocation location, WorkflowElementProperties props) throws Exception {
        String moduleKey = props.getModuleKey();
        String viewFileName = moduleKey + ".vm";
        String inputFileName = moduleKey + "-input.vm";
        String packageName = props.getPackage();
        String functionClass = props.getClassname();
        String factoryClass = props.getFactoryName();
        File templatesDir = new File(location.getTemplateDirectory(), "conditions");
        this.templateHelper.writeJavaClassFromTemplate(CLASS_TEMPLATE, functionClass, location.getSourceDirectory(), packageName, props);
        this.templateHelper.writeJavaClassFromTemplate(FACTORY_TEMPLATE, factoryClass, location.getSourceDirectory(), packageName, props);
        this.templateHelper.writeJavaClassFromTemplate(UNIT_TEST_TEMPLATE, this.testClassname(functionClass), location.getTestDirectory(), packageName, props);
        this.templateHelper.writeFileFromTemplate(VIEW_TEMPLATE, viewFileName, templatesDir, props);
        this.templateHelper.writeFileFromTemplate(INPUT_TEMPLATE, inputFileName, templatesDir, props);
        this.addModuleToPluginXml(PLUGIN_MODULE_TEMPLATE, location, props);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

