/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.plugins.codegen.annotations.Dependencies;
import com.atlassian.plugins.codegen.annotations.Dependency;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.jira.TabPanelProperties;
import java.io.File;

@JiraPluginModuleCreator
@Dependencies(value={@Dependency(groupId="org.mockito", artifactId="mockito-all", version="1.8.5", scope="test")})
public class VersionTabPanelModuleCreator
extends AbstractPluginModuleCreator<TabPanelProperties> {
    public static final String GENERIC_CLASS = "GenericTabPanel";
    public static final String GENERIC_PACKAGE = "com.atlassian.jira.plugin.versionpanel.impl";
    public static final String FQ_GENERIC_CLASS = "com.atlassian.jira.plugin.versionpanel.impl.GenericTabPanel";
    public static final String MODULE_NAME = "Version Tab Panel";
    private static final String TEMPLATE_PREFIX = "templates/jira/tabpanel/version/";
    private static final String CLASS_TEMPLATE = "templates/jira/tabpanel/version/VersionTabPanel.java.vtl";
    private static final String UNIT_TEST_TEMPLATE = "templates/generic/GenericTest.java.vtl";
    private static final String FUNC_TEST_TEMPLATE = "templates/jira/tabpanel/version/VersionTabPanelFuncTest.java.vtl";
    private static final String VIEW_TEMPLATE = "templates/jira/tabpanel/version/version-tab-panel.vm.vtl";
    private static final String EXAMPLE_CLASS_TEMPLATE = "templates/jira/tabpanel/version/Exampletemplates/jira/tabpanel/version/VersionTabPanel.java.vtl";
    private static final String PLUGIN_MODULE_TEMPLATE = "templates/jira/tabpanel/version/version-tab-panel-plugin.xml.vtl";

    @Override
    public void createModule(PluginModuleLocation location, TabPanelProperties props) throws Exception {
        String moduleKey = props.getModuleKey();
        String packageName = props.getPackage();
        String classname = props.getClassname();
        String viewFileName = moduleKey + ".vm";
        File templatesDir = new File(location.getTemplateDirectory(), "tabpanels");
        if (props.includeExamples()) {
            this.templateHelper.writeJavaClassFromTemplate(EXAMPLE_CLASS_TEMPLATE, classname, location.getSourceDirectory(), packageName, props);
        } else {
            if (props.isUseCustomClass()) {
                this.templateHelper.writeJavaClassFromTemplate(CLASS_TEMPLATE, classname, location.getSourceDirectory(), packageName, props);
                this.templateHelper.writeJavaClassFromTemplate(UNIT_TEST_TEMPLATE, this.testClassname(classname), location.getTestDirectory(), packageName, props);
            }
            this.templateHelper.writeFileFromTemplate(VIEW_TEMPLATE, viewFileName, templatesDir, props);
        }
        this.addModuleToPluginXml(PLUGIN_MODULE_TEMPLATE, location, props);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

