/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.plugins.codegen.annotations.Dependencies;
import com.atlassian.plugins.codegen.annotations.Dependency;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.common.Resource;
import com.atlassian.plugins.codegen.modules.jira.CustomFieldProperties;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

@JiraPluginModuleCreator
@Dependencies(value={@Dependency(groupId="org.mockito", artifactId="mockito-all", version="1.8.5", scope="test")})
public class CustomFieldModuleCreator
extends AbstractPluginModuleCreator<CustomFieldProperties> {
    public static final String MODULE_NAME = "Custom Field";
    private static final String TEMPLATE_PREFIX = "templates/jira/customfield/";
    private static final String CLASS_TEMPLATE = "templates/jira/customfield/CustomField.java.vtl";
    private static final String UNIT_TEST_TEMPLATE = "templates/generic/GenericTest.java.vtl";
    private static final String FUNC_TEST_TEMPLATE = "templates/jira/customfield/CustomFieldFuncTest.java.vtl";
    private static final String VIEW_TEMPLATE = "templates/common/actionview.vm.vtl";
    private static final String EXAMPLE_CLASS_TEMPLATE = "templates/jira/customfield/Exampletemplates/jira/customfield/CustomField.java.vtl";
    private static final String PLUGIN_MODULE_TEMPLATE = "templates/jira/customfield/custom-field-plugin.xml.vtl";

    @Override
    public void createModule(PluginModuleLocation location, CustomFieldProperties props) throws Exception {
        String packageName = props.getPackage();
        String classname = props.getClassname();
        if (props.includeExamples()) {
            this.templateHelper.writeJavaClassFromTemplate(EXAMPLE_CLASS_TEMPLATE, classname, location.getSourceDirectory(), packageName, props);
        } else {
            this.templateHelper.writeJavaClassFromTemplate(CLASS_TEMPLATE, classname, location.getSourceDirectory(), packageName, props);
            this.templateHelper.writeJavaClassFromTemplate(UNIT_TEST_TEMPLATE, this.testClassname(classname), location.getTestDirectory(), packageName, props);
            for (Resource resource : props.getResources()) {
                String resourcePath = FilenameUtils.separatorsToSystem((String)resource.getLocation());
                if (resourcePath.startsWith("templates" + File.separator) || resourcePath.startsWith(File.separator + "templates" + File.separator)) {
                    resourcePath = StringUtils.substringAfter((String)resourcePath, (String)("templates" + File.separator));
                }
                File resourceFolder = new File(location.getTemplateDirectory(), FilenameUtils.getPath((String)resourcePath));
                String resourceFile = FilenameUtils.getName((String)resourcePath);
                props.setProperty("CURRENT_VIEW", resourceFile);
                this.templateHelper.writeFileFromTemplate(VIEW_TEMPLATE, FilenameUtils.getName((String)resourcePath), resourceFolder, props);
            }
        }
        this.addModuleToPluginXml(PLUGIN_MODULE_TEMPLATE, location, props);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

