/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.ClassId;
import com.atlassian.plugins.codegen.ComponentDeclaration;
import com.atlassian.plugins.codegen.ComponentImport;
import com.atlassian.plugins.codegen.I18nString;
import com.atlassian.plugins.codegen.ModuleDescriptor;
import com.atlassian.plugins.codegen.PluginParameter;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.ProjectRewriter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.util.PluginXmlHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class PluginXmlRewriter
implements ProjectRewriter {
    private final PluginXmlHelper xmlHelper;
    private final Document document;

    public PluginXmlRewriter(PluginModuleLocation location) throws IOException, DocumentException {
        this.xmlHelper = new PluginXmlHelper(location);
        this.document = this.xmlHelper.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges(PluginProjectChangeset changes) throws IOException {
        boolean modified = false;
        try {
            if (changes.hasItems(I18nString.class)) {
                modified |= this.addI18nResource(this.xmlHelper.getDefaultI18nName(), this.xmlHelper.getDefaultI18nLocation());
            }
            for (PluginParameter pluginParam : changes.getItems(PluginParameter.class)) {
                modified |= this.addPluginInfoParam(pluginParam.getName(), pluginParam.getValue());
            }
            for (ComponentImport componentImport : changes.getItems(ComponentImport.class)) {
                modified |= this.addComponentImport(componentImport);
            }
            for (ComponentDeclaration component : changes.getItems(ComponentDeclaration.class)) {
                modified |= this.addComponentDeclaration(component);
            }
            for (ModuleDescriptor moduleDescriptor : changes.getItems(ModuleDescriptor.class)) {
                modified |= this.addModuleAsLastChild(moduleDescriptor.getContent());
            }
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        if (modified) {
            OutputFormat format = OutputFormat.createPrettyPrint();
            FileOutputStream fos = new FileOutputStream(this.xmlHelper.getXmlFile());
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            XMLWriter writer = new XMLWriter((Writer)osw, format);
            try {
                writer.write(this.document);
            }
            finally {
                writer.close();
                IOUtils.closeQuietly((Writer)osw);
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
    }

    private Element createModule(String type) {
        Element newElement = this.document.getRootElement().addElement(type);
        List existingModules = this.document.getRootElement().elements(type);
        if (!existingModules.isEmpty()) {
            newElement.detach();
            existingModules.add(newElement);
        }
        return newElement;
    }

    private boolean addModuleAsLastChild(Element module) {
        String key = module.attributeValue("key");
        if (key == null || !PluginXmlHelper.findElementByTypeAndAttribute(this.document.getRootElement(), module.getName(), "key", key).isDefined()) {
            Element pluginRoot = this.document.getRootElement();
            pluginRoot.add(module);
            return true;
        }
        return false;
    }

    private boolean addI18nResource(String name, String location) throws DocumentException, IOException {
        String xpath = "//resource[@type='i18n' and (@name = '" + name + "' or @location='" + location + "')]";
        Node resourceNode = this.document.selectSingleNode(xpath);
        if (resourceNode == null) {
            Element resource = this.document.getRootElement().addElement("resource");
            resource.addAttribute("type", "i18n");
            resource.addAttribute("name", name);
            resource.addAttribute("location", location);
            return true;
        }
        return false;
    }

    private boolean addPluginInfoParam(String name, String value) {
        Element pluginInfo = (Element)this.document.selectSingleNode("//plugin-info");
        if (pluginInfo == null) {
            pluginInfo = this.document.addElement("plugin-info");
        }
        if (!PluginXmlHelper.findElementByTypeAndAttribute(pluginInfo, "param", "name", name).isDefined()) {
            pluginInfo.addElement("param").addAttribute("name", name).setText(value);
            return true;
        }
        return false;
    }

    private boolean addComponentImport(ComponentImport componentImport) throws DocumentException {
        String key = (String)componentImport.getKey().getOrElse((Object)this.createKeyFromClass(componentImport.getInterfaceClass()));
        for (ClassId interfaceId : Iterables.concat((Iterable)ImmutableList.of((Object)componentImport.getInterfaceClass()), (Iterable)componentImport.getAlternateInterfaces())) {
            if (this.document.getRootElement().selectNodes("//component-import[@interface='" + interfaceId.getFullName() + "']").size() <= 0 && this.document.getRootElement().selectNodes("//component-import/interface[text()='" + interfaceId.getFullName() + "']").size() <= 0) continue;
            return false;
        }
        if (PluginXmlHelper.findElementByTypeAndAttribute(this.document.getRootElement(), "component-import", "key", key).isDefined()) {
            return false;
        }
        Element element = this.createModule("component-import");
        element.addAttribute("key", key);
        element.addAttribute("interface", componentImport.getInterfaceClass().getFullName());
        for (String filter : componentImport.getFilter()) {
            element.addAttribute("filter", filter);
        }
        return true;
    }

    private boolean addComponentDeclaration(ComponentDeclaration component) throws DocumentException {
        if (!PluginXmlHelper.findElementByTypeAndAttribute(this.document.getRootElement(), "component", "key", component.getKey()).isDefined()) {
            Element element = this.createModule("component");
            element.addAttribute("key", component.getKey());
            element.addAttribute("class", component.getClassId().getFullName());
            for (String name : component.getName()) {
                element.addAttribute("name", name);
            }
            for (String nameI18nKey : component.getNameI18nKey()) {
                element.addAttribute("i18n-name-key", nameI18nKey);
            }
            if (component.getVisibility() == ComponentDeclaration.Visibility.PUBLIC) {
                element.addAttribute("public", "true");
            }
            for (String alias : component.getAlias()) {
                element.addAttribute("alias", alias);
            }
            for (String description : component.getDescription()) {
                Element eDesc = element.addElement("description");
                eDesc.setText(description);
                for (String descI18nKey : component.getDescriptionI18nKey()) {
                    eDesc.addAttribute("key", descI18nKey);
                }
            }
            for (ClassId interfaceId : component.getInterfaceId()) {
                element.addElement("interface").setText(interfaceId.getFullName());
            }
            if (!component.getServiceProperties().isEmpty()) {
                Element eProps = element.addElement("service-properties");
                for (Map.Entry entry : component.getServiceProperties().entrySet()) {
                    Element eEntry = eProps.addElement("entry");
                    eEntry.addAttribute("key", (String)entry.getKey());
                    eEntry.addAttribute("value", (String)entry.getValue());
                }
            }
            return true;
        }
        return false;
    }

    private String createKeyFromClass(ClassId classId) {
        return this.lowercaseFirst(classId.getName());
    }

    private String lowercaseFirst(String input) {
        return input.equals("") ? input : input.substring(0, 1).toLowerCase() + input.substring(1);
    }
}

