/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import java.util.Objects;
import java.util.Optional;

public final class ArtifactId {
    private final Optional<String> groupId;
    private final String artifactIdStr;

    public static ArtifactId artifactId(String artifactId) {
        return new ArtifactId(Optional.empty(), artifactId);
    }

    public static ArtifactId artifactId(String groupId, String artifactId) {
        return new ArtifactId(Optional.of(groupId), artifactId);
    }

    public static ArtifactId artifactId(Optional<String> groupId, String artifactId) {
        return new ArtifactId(groupId, artifactId);
    }

    private ArtifactId(Optional<String> groupId, String artifactId) {
        this.groupId = Objects.requireNonNull(groupId, "groupId");
        this.artifactIdStr = Objects.requireNonNull(artifactId, "artifactId");
    }

    public Optional<String> getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactIdStr;
    }

    public String getCombinedId() {
        String prefix = this.groupId.map(g -> g + ":").orElse("");
        return prefix + this.artifactIdStr;
    }

    public String toString() {
        return this.getCombinedId();
    }

    public boolean equals(Object other) {
        if (other instanceof ArtifactId) {
            ArtifactId c = (ArtifactId)other;
            return this.groupId.equals(c.groupId) && this.artifactIdStr.equals(c.artifactIdStr);
        }
        return false;
    }

    public int hashCode() {
        return this.getCombinedId().hashCode();
    }
}

