/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.ArtifactId;
import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.VersionId;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;

public final class ArtifactDependency
implements PluginProjectChange {
    private ArtifactId artifactId;
    private VersionId versionId;
    private Scope scope;

    public static ArtifactDependency dependency(String groupId, String artifactId, VersionId versionId, Scope scope) {
        return new ArtifactDependency(ArtifactId.artifactId((Option<String>)Option.some((Object)groupId), artifactId), versionId, scope);
    }

    public static ArtifactDependency dependency(String groupId, String artifactId, String version, Scope scope) {
        return new ArtifactDependency(ArtifactId.artifactId((Option<String>)Option.some((Object)groupId), artifactId), VersionId.version(version), scope);
    }

    public static ArtifactDependency dependency(ArtifactId groupAndArtifactId, VersionId versionId, Scope scope) {
        return new ArtifactDependency(groupAndArtifactId, versionId, scope);
    }

    public static ArtifactDependency dependency(ArtifactId groupAndArtifactId, String version, Scope scope) {
        return new ArtifactDependency(groupAndArtifactId, VersionId.version(version), scope);
    }

    private ArtifactDependency(ArtifactId artifactId, VersionId versionId, Scope scope) {
        this.artifactId = (ArtifactId)Preconditions.checkNotNull((Object)artifactId, (Object)"artifactId");
        if (!artifactId.getGroupId().isDefined()) {
            throw new IllegalArgumentException("Group ID must be specified for dependency");
        }
        this.versionId = (VersionId)Preconditions.checkNotNull((Object)versionId, (Object)"versionId");
        if (!versionId.getVersion().isDefined()) {
            throw new IllegalArgumentException("Version must be specified for dependency");
        }
        this.scope = (Scope)((Object)Preconditions.checkNotNull((Object)((Object)scope), (Object)"scope"));
    }

    public ArtifactId getGroupAndArtifactId() {
        return this.artifactId;
    }

    public VersionId getVersionId() {
        return this.versionId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String toString() {
        return "[dependency: " + this.artifactId + "]";
    }

    public static enum Scope {
        DEFAULT,
        COMPILE,
        PROVIDED,
        TEST;

    }
}

