/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.SummarizeAsGroup;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;

public final class BundleInstruction
implements PluginProjectChange,
SummarizeAsGroup {
    private Category category;
    private String packageName;
    private Option<String> version;

    public static BundleInstruction importPackage(String packageName, String version) {
        return new BundleInstruction(Category.IMPORT, packageName, (Option<String>)Option.some((Object)version));
    }

    public static BundleInstruction dynamicImportPackage(String packageName, String version) {
        return new BundleInstruction(Category.DYNAMIC_IMPORT, packageName, (Option<String>)Option.some((Object)version));
    }

    public static BundleInstruction privatePackage(String packageName) {
        return new BundleInstruction(Category.PRIVATE, packageName, (Option<String>)Option.none(String.class));
    }

    public BundleInstruction(Category category, String packageName, Option<String> version) {
        this.category = (Category)((Object)Preconditions.checkNotNull((Object)((Object)category), (Object)"category"));
        this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"packageName");
        this.version = (Option)Preconditions.checkNotNull(version, (Object)"version");
    }

    public Category getCategory() {
        return this.category;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Option<String> getVersion() {
        return this.version;
    }

    @Override
    public String getGroupName() {
        return "bundle instructions";
    }

    public String toString() {
        return "[bundle instruction: " + this.category.getElementName() + " " + this.packageName + "]";
    }

    public static enum Category {
        IMPORT("Import-Package"),
        PRIVATE("Private-Package"),
        DYNAMIC_IMPORT("DynamicImport-Package");

        private String elementName;

        private Category(String elementName) {
            this.elementName = elementName;
        }

        public String getElementName() {
            return this.elementName;
        }
    }
}

