/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;
import java.util.Iterator;

public final class ArtifactId {
    private final Option<String> groupId;
    private final String artifactId;

    public static ArtifactId artifactId(String artifactId) {
        return new ArtifactId((Option<String>)Option.none(String.class), artifactId);
    }

    public static ArtifactId artifactId(String groupId, String artifactId) {
        return new ArtifactId((Option<String>)Option.some((Object)groupId), artifactId);
    }

    public static ArtifactId artifactId(Option<String> groupId, String artifactId) {
        return new ArtifactId(groupId, artifactId);
    }

    private ArtifactId(Option<String> groupId, String artifactId) {
        this.groupId = (Option)Preconditions.checkNotNull(groupId, (Object)"groupId");
        this.artifactId = (String)Preconditions.checkNotNull((Object)artifactId, (Object)"artifactId");
    }

    public Option<String> getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getCombinedId() {
        Iterator iterator = this.groupId.iterator();
        if (iterator.hasNext()) {
            String g = (String)iterator.next();
            return g + ":" + this.artifactId;
        }
        return this.artifactId;
    }

    public String toString() {
        return this.getCombinedId();
    }

    public boolean equals(Object other) {
        if (other instanceof ArtifactId) {
            ArtifactId c = (ArtifactId)other;
            return this.groupId.equals(c.groupId) && this.artifactId.equals(c.artifactId);
        }
        return false;
    }

    public int hashCode() {
        return this.getCombinedId().hashCode();
    }
}

