/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.fugue.Option;
import com.atlassian.plugins.codegen.ClassId;
import com.atlassian.plugins.codegen.PluginProjectChange;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;

public final class ComponentDeclaration
implements PluginProjectChange {
    private final ClassId classId;
    private final String key;
    private final Visibility visibility;
    private final Option<String> name;
    private final Option<String> nameI18nKey;
    private final Option<String> description;
    private final Option<String> descriptionI18nKey;
    private final Option<ClassId> interfaceId;
    private final Option<String> alias;
    private final ImmutableMap<String, String> serviceProperties;

    public static Builder builder(ClassId classId, String key) {
        return new Builder(classId, key);
    }

    public static ComponentDeclaration componentDeclaration(ClassId classId, String key) {
        return ComponentDeclaration.builder(classId, key).build();
    }

    private ComponentDeclaration(Builder builder) {
        this.classId = builder.classId;
        this.visibility = builder.visibility;
        this.key = builder.key;
        this.name = builder.name;
        this.nameI18nKey = builder.nameI18nKey;
        this.description = builder.description;
        this.descriptionI18nKey = builder.descriptionI18nKey;
        this.interfaceId = builder.interfaceId;
        this.alias = builder.alias;
        this.serviceProperties = ImmutableMap.copyOf((Map)builder.serviceProperties);
    }

    public ClassId getClassId() {
        return this.classId;
    }

    public String getKey() {
        return this.key;
    }

    public Option<ClassId> getInterfaceId() {
        return this.interfaceId;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Option<String> getName() {
        return this.name;
    }

    public Option<String> getNameI18nKey() {
        return this.nameI18nKey;
    }

    public Option<String> getDescription() {
        return this.description;
    }

    public Option<String> getDescriptionI18nKey() {
        return this.descriptionI18nKey;
    }

    public Option<String> getAlias() {
        return this.alias;
    }

    public ImmutableMap<String, String> getServiceProperties() {
        return this.serviceProperties;
    }

    public String toString() {
        return "[component: " + this.classId + "]";
    }

    public static class Builder {
        private final ClassId classId;
        private final String key;
        private Visibility visibility = Visibility.PRIVATE;
        private Option<String> name = Option.none();
        private Option<String> nameI18nKey = Option.none();
        private Option<String> description = Option.none();
        private Option<String> descriptionI18nKey = Option.none();
        private Option<ClassId> interfaceId = Option.none();
        private Option<String> alias = Option.none();
        private Map<String, String> serviceProperties = Maps.newHashMap();

        public Builder(ClassId classId, String key) {
            this.classId = (ClassId)Preconditions.checkNotNull((Object)classId, (Object)"classId");
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
        }

        public ComponentDeclaration build() {
            return new ComponentDeclaration(this);
        }

        public Builder interfaceId(Option<ClassId> interfaceId) {
            this.interfaceId = (Option)Preconditions.checkNotNull(interfaceId, (Object)"interfaceId");
            return this;
        }

        public Builder visibility(Visibility visibility) {
            this.visibility = (Visibility)((Object)Preconditions.checkNotNull((Object)((Object)visibility), (Object)"visibility"));
            return this;
        }

        public Builder name(Option<String> name) {
            this.name = (Option)Preconditions.checkNotNull(name, (Object)"name");
            return this;
        }

        public Builder nameI18nKey(Option<String> nameI18nKey) {
            this.nameI18nKey = (Option)Preconditions.checkNotNull(nameI18nKey, (Object)"nameI18nKey");
            return this;
        }

        public Builder description(Option<String> description) {
            this.description = (Option)Preconditions.checkNotNull(description, (Object)"description");
            return this;
        }

        public Builder descriptionI18nKey(Option<String> descriptionI18nKey) {
            this.descriptionI18nKey = (Option)Preconditions.checkNotNull(descriptionI18nKey, (Object)"descriptionI18nKey");
            return this;
        }

        public Builder alias(Option<String> alias) {
            this.alias = (Option)Preconditions.checkNotNull(alias, (Object)"alias");
            return this;
        }

        public Builder serviceProperties(Map<String, String> serviceProperties) {
            this.serviceProperties.putAll((Map)Preconditions.checkNotNull(serviceProperties, (Object)"serviceProperties"));
            return this;
        }
    }

    public static enum Visibility {
        PUBLIC,
        PRIVATE;

    }
}

