/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@ReturnValuesAreNonnullByDefault
@Internal
public class EnumParser<E extends Enum<E>> {
    private final String enumName;
    private final Map<String, E> lookup;

    public EnumParser(Class<E> enumClass, Function<E, String> keyExtractor) {
        this.enumName = EnumParser.nameOf(enumClass);
        this.lookup = Collections.unmodifiableMap(Arrays.stream((Enum[])enumClass.getEnumConstants()).collect(Collectors.toMap(keyExtractor, Function.identity())));
    }

    public E parse(@Nullable String key) {
        Enum found;
        if (key != null && (found = (Enum)this.lookup.get(key)) != null) {
            return (E)found;
        }
        throw new AdfException.UnsupportedEnumValue(this.enumName, key);
    }

    @Nullable
    public E parseAllowNull(@Nullable String key) {
        return key != null ? (E)this.parse(key) : null;
    }

    private static String nameOf(Class<?> enumClass) {
        Objects.requireNonNull(enumClass, "enumClass");
        String enumName = Objects.requireNonNull(enumClass.getSimpleName(), "enumName");
        if (enumName.isEmpty()) {
            throw new IllegalStateException("How did we get a blank enumName?!");
        }
        return Character.toLowerCase(enumName.charAt(0)) + enumName.substring(1);
    }
}

