/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.adf.util.Char;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;

@ReturnValuesAreNonnullByDefault
@Internal
public class DateUtil {
    private static final String NOT_A_NUMBER = "NaN-NaN-NaN";

    public static String timestampToIsoFormat(String timestamp) {
        LocalDate localDate;
        try {
            localDate = DateUtil.parseDate(timestamp);
        }
        catch (DateTimeParseException e) {
            return NOT_A_NUMBER;
        }
        StringBuilder sb = new StringBuilder().append(localDate.getYear()).append('-');
        int month = localDate.getMonthValue();
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month).append('-');
        int day = localDate.getDayOfMonth();
        if (day < 10) {
            sb.append('0');
        }
        return sb.append(day).toString();
    }

    private static LocalDate parseDate(String timestamp) {
        if (DateUtil.isPureNumeric(timestamp)) {
            long millis = Long.parseLong(timestamp);
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDate.ofInstant(instant, ZoneOffset.UTC);
        }
        try {
            return ZonedDateTime.parse(timestamp).withZoneSameInstant(ZoneOffset.UTC).toLocalDate();
        }
        catch (DateTimeParseException ignore) {
            return LocalDate.parse(timestamp);
        }
    }

    private static boolean isPureNumeric(String s) {
        switch (s.length()) {
            case 0: {
                return false;
            }
            case 1: {
                return Char.isDigit(s.charAt(0));
            }
        }
        char c = s.charAt(0);
        if (!Char.isDigit(c) && c != '-') {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Char.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

