/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.mark.type.ExtensionMark;
import com.atlassian.adf.model.node.AbstractMarkedNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.ExtensionSettings;
import com.atlassian.adf.model.node.type.BlockquoteContent;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.ExtensionFrameContent;
import com.atlassian.adf.model.node.type.ExtensionNode;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.PanelContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.model.node.unsupported.UnsupportedNode;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class Extension
extends AbstractMarkedNode<Extension, ExtensionMark>
implements ExtensionNode<Extension, ExtensionMark>,
BlockquoteContent,
DocContent,
ExtensionFrameContent,
LayoutColumnContent,
ListItemContent,
NestedExpandContent,
NonNestableBlockContent,
PanelContent,
TableCellContent {
    static final Factory<Extension> FACTORY = new Factory<Extension>("extension", Extension.class, Extension::parse);
    private final ExtensionSettings settings;
    @Nullable
    private ExtensionSettings.Layout layout;

    private Extension(ExtensionSettings settings) {
        this.settings = settings;
    }

    @CheckReturnValue
    public static ExtensionSettings.Partial.NeedsExtensionKey<Extension> extension() {
        return new ExtensionSettings.Partial.NeedsExtensionKey<Extension>(Extension::new);
    }

    public static Extension extension(String extensionKey, String extensionType) {
        return ExtensionSettings.extensionSettings(Extension::new).extensionKey(extensionKey).extensionType(extensionType);
    }

    @Override
    public Extension copy() {
        return Extension.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "extension";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", this.settings.toExtensionAttrs().addMappedIfPresent("layout", this.layout, ExtensionSettings.Layout::layout)).let(this.marks::addToMap);
    }

    @Override
    public Class<ExtensionMark> markClass() {
        return ExtensionMark.class;
    }

    @Override
    protected int markedNodeHashCode() {
        return Objects.hash(new Object[]{this.settings, this.layout});
    }

    @Override
    protected boolean markedNodeEquals(Extension other) {
        return this.layout == other.layout && this.settings.equals(other.settings);
    }

    @Override
    protected void appendMarkedNodeFields(AbstractNode.ToStringHelper buf) {
        this.settings.appendExtensionFields(buf);
        buf.appendField("layout", (Object)this.layout);
    }

    @Override
    public String extensionKey() {
        return this.settings.extensionKey();
    }

    @Override
    public Extension extensionKey(String extensionKey) {
        this.settings.extensionKey(extensionKey);
        return this;
    }

    @Override
    public String extensionType() {
        return this.settings.extensionType();
    }

    @Override
    public Extension extensionType(String extensionType) {
        this.settings.extensionType(extensionType);
        return this;
    }

    @Override
    public Extension localId(@Nullable String localId) {
        this.settings.localId(localId);
        return this;
    }

    @Override
    public Optional<String> localId() {
        return this.settings.localId();
    }

    @Override
    public Extension text(@Nullable String text) {
        this.settings.text(text);
        return this;
    }

    @Override
    public Optional<String> text() {
        return this.settings.text();
    }

    @Override
    public Extension parameters(@Nullable Map<String, ?> parameters) {
        this.settings.parameters(parameters);
        return this;
    }

    @Override
    public Optional<Map<String, ?>> parameters() {
        return this.settings.parameters();
    }

    public Extension layout(@Nullable String layout) {
        return this.layout(ExtensionSettings.Layout.PARSER.parseAllowNull(layout));
    }

    public Extension layout(@Nullable ExtensionSettings.Layout layout) {
        this.layout = layout;
        return this;
    }

    public Optional<ExtensionSettings.Layout> layout() {
        return Optional.ofNullable(this.layout);
    }

    private static Extension parse(Map<String, ?> map) {
        ExtensionSettings settings = ExtensionSettings.parse(map);
        Extension extension = new Extension(settings);
        ParserSupport.getAttr(map, "layout", String.class).ifPresent(layout -> extension.layout(ExtensionSettings.Layout.PARSER.parse((String)layout)));
        return (Extension)extension.parseMarks(map);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        String text = this.settings.text().orElseGet(() -> UnsupportedNode.plainTextFallback(this));
        sb.append(text);
    }
}

