/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.mark.AbstractMark;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.model.mark.MarkKeys;
import com.atlassian.adf.model.mark.type.CodeTextMark;
import com.atlassian.adf.model.mark.type.FormattedTextMark;
import com.atlassian.adf.model.mark.type.MediaInlineMark;
import com.atlassian.adf.model.mark.type.MediaMark;
import com.atlassian.adf.model.mark.type.MediaSingleMark;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.INCOMPLETE, date="2023-07-26", comment="missing descriptions for media attributes")
public class Link
extends AbstractMark
implements CodeTextMark,
FormattedTextMark,
MediaMark,
MediaInlineMark,
MediaSingleMark {
    static final MarkKey MARK_KEY = MarkKeys.byClass(Link.class);
    static final Factory<Link> FACTORY = new Factory<Link>("link", Link.class, Link::parse);
    private String href;
    @Nullable
    private String title;
    @Nullable
    private String collection;
    @Nullable
    private String id;
    @Nullable
    private String occurrenceKey;

    private Link(String href) {
        this.href = Objects.requireNonNull(href, "url");
    }

    public static Link a(String href) {
        return Link.link(href);
    }

    public static Link a(URL href) {
        return Link.link(href);
    }

    public static Link a(URI href) {
        return Link.link(href);
    }

    public static Link link(String href) {
        return new Link(ParserSupport.cleanUri(href, "href"));
    }

    public static Link link(URL href) {
        return new Link(ParserSupport.cleanUri(href, "href"));
    }

    public static Link link(URI href) {
        return new Link(ParserSupport.cleanUri(href, "href"));
    }

    public Optional<String> title() {
        return Optional.ofNullable(this.title);
    }

    public String href() {
        return this.href;
    }

    public Link href(String href) {
        this.href = ParserSupport.cleanUri(href, "href");
        return this;
    }

    public Link href(URL href) {
        this.href = ParserSupport.cleanUri(href, "href");
        return this;
    }

    public Link href(URI href) {
        this.href = ParserSupport.cleanUri(href, "href");
        return this;
    }

    public Link title(@Nullable String title) {
        this.title = title;
        return this;
    }

    public Optional<String> collection() {
        return Optional.ofNullable(this.collection);
    }

    public Link collection(@Nullable String collection) {
        this.collection = collection;
        return this;
    }

    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    public Link id(String id) {
        this.id = id;
        return this;
    }

    public Optional<String> occurrenceKey() {
        return Optional.ofNullable(this.occurrenceKey);
    }

    public Link occurrenceKey(String occurrenceKey) {
        this.occurrenceKey = occurrenceKey;
        return this;
    }

    @Override
    public Link copy() {
        return Link.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "link";
    }

    @Override
    public MarkKey markKey() {
        return MARK_KEY;
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map("href", this.href).addIfPresent("title", this.title).addIfPresent("collection", this.collection).addIfPresent("id", this.id).addIfPresent("occurrenceKey", this.occurrenceKey));
    }

    private static Link parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "link");
        Link link = new Link(ParserSupport.getAttrOrThrow(map, "href", String.class));
        ParserSupport.getAttr(map, "title", String.class).ifPresent(link::title);
        ParserSupport.getAttr(map, "collection", String.class).ifPresent(link::collection);
        ParserSupport.getAttr(map, "id", String.class).ifPresent(link::id);
        ParserSupport.getAttr(map, "occurrenceKey", String.class).ifPresent(link::occurrenceKey);
        return link;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return this.href.equals(link.href) && Objects.equals(this.title, link.title) && Objects.equals(this.id, link.id) && Objects.equals(this.collection, link.collection) && Objects.equals(this.occurrenceKey, link.occurrenceKey);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.title, this.id, this.collection, this.occurrenceKey);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.elementType()).append("[href=").append(this.href);
        if (this.title != null) {
            sb.append(", title=").append(this.title);
        }
        if (this.id != null) {
            sb.append(", id=").append(this.id);
        }
        if (this.collection != null) {
            sb.append(", collection=").append(this.collection);
        }
        if (this.occurrenceKey != null) {
            sb.append(", occurrenceKey=").append(this.occurrenceKey);
        }
        return sb.append(']').toString();
    }
}

