/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.ex.mark.BackgroundColorException;
import com.atlassian.adf.model.mark.AbstractMark;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.model.mark.MarkKeys;
import com.atlassian.adf.model.mark.type.FormattedTextMark;
import com.atlassian.adf.util.Colors;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.awt.Color;
import java.util.Map;
import java.util.Objects;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2024-05-02", comment="Nothing has been added to the internal documentation for this feature, yet")
public class BackgroundColor
extends AbstractMark
implements FormattedTextMark {
    static final MarkKey MARK_KEY = MarkKeys.byClass(BackgroundColor.class);
    static final Factory<BackgroundColor> FACTORY = new Factory<BackgroundColor>("backgroundColor", BackgroundColor.class, BackgroundColor::parse);
    private String color;

    private BackgroundColor(String color) {
        this.color = BackgroundColor.validateColor(color);
    }

    public static BackgroundColor backgroundColor(String color) {
        return new BackgroundColor(color);
    }

    public static BackgroundColor backgroundColor(Color color) {
        return BackgroundColor.backgroundColor(Colors.hex6(color));
    }

    public static BackgroundColor backgroundColor(Colors.Named color) {
        return BackgroundColor.backgroundColor(color.toHex());
    }

    public String color() {
        return this.color;
    }

    public BackgroundColor color(String color) {
        this.color = BackgroundColor.validateColor(color);
        return this;
    }

    public BackgroundColor color(Color color) {
        return BackgroundColor.backgroundColor(Colors.hex6(color));
    }

    @Override
    public BackgroundColor copy() {
        return BackgroundColor.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "backgroundColor";
    }

    @Override
    public MarkKey markKey() {
        return MARK_KEY;
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map("color", this.color));
    }

    public boolean equals(Object o) {
        return this == o || o instanceof BackgroundColor && this.color.equals(((BackgroundColor)o).color);
    }

    public int hashCode() {
        return this.color.hashCode();
    }

    @Override
    public String toString() {
        return this.elementType() + "[" + this.color + "]";
    }

    private static BackgroundColor parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "backgroundColor");
        String color = (String)ParserSupport.getAttrOrThrow(map, "color");
        return BackgroundColor.backgroundColor(color);
    }

    private static String validateColor(String color) {
        Objects.requireNonNull(color, "color");
        if (!Colors.isHex6(color)) {
            throw new BackgroundColorException.InvalidColor(color);
        }
        return color;
    }
}

