/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model;

import com.atlassian.adf.util.Cast;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Skeleton {
    public static final Format DEFAULT_FORMAT = Format.COMPACT;
    public static final boolean DEFAULT_INCLUDE_MARKS = true;
    public static final boolean DEFAULT_INCLUDE_NODE_ATTRS = false;
    private static final String INDENT = "  ";
    private static final int BUFFER_SIZE = 4096;
    private static final char SPACE = ' ';
    private static final char NEWLINE = '\n';
    public static final String SHORT_SKELETON_PREFIX = "adfskel:";
    public static final char OPEN_NODE = '{';
    public static final char CLOSE_NODE = '}';
    public static final char OPEN_MARKS = '[';
    public static final char CLOSE_MARKS = ']';
    public static final char OPEN_ATTRS = '<';
    public static final char CLOSE_ATTRS = '>';
    public static final char OPEN_CLASS = "\u00ab".charAt(0);
    public static final char CLOSE_CLASS = "\u00bb".charAt(0);
    public static final char LIST_SEPARATOR = ',';
    public static final char CONTENT_INDICATOR = ':';
    private final Map<String, ?> adf;
    private boolean includeMarks = true;
    private boolean includeNodeAttrs = false;
    private Format format = DEFAULT_FORMAT;

    private Skeleton(Map<String, ?> adf) {
        this.adf = Objects.requireNonNull(adf, "adf");
    }

    public static Skeleton skeleton(Map<String, ?> adf) {
        return new Skeleton(adf);
    }

    public Skeleton format(Format format) {
        this.format = Objects.requireNonNull(format, "format");
        return this;
    }

    public Skeleton compact() {
        return this.format(Format.COMPACT);
    }

    public Skeleton pretty() {
        return this.format(Format.PRETTY);
    }

    public Skeleton includeMarks(boolean includeMarks) {
        this.includeMarks = includeMarks;
        return this;
    }

    public Skeleton includeNodeAttrs(boolean includeNodeAttrs) {
        this.includeNodeAttrs = includeNodeAttrs;
        return this;
    }

    public String toString() {
        return this.format.format(this.node(this.adf));
    }

    private SkeletonNode node(Map<String, ?> element) {
        try {
            SkeletonNode node = new SkeletonNode(this.type(element));
            this.content(node, element);
            if (this.includeMarks) {
                this.marks(node, element);
            }
            if (this.includeNodeAttrs) {
                this.attrs(node, element);
            }
            return node;
        }
        catch (RuntimeException e) {
            return new SkeletonNode(Skeleton.ex(e));
        }
    }

    private String type(Map<String, ?> element) {
        try {
            Object type = element.get("type");
            if (type == null) {
                return Skeleton.err(ErrorType.TYPE_NULL);
            }
            if (type instanceof String) {
                String s = (String)type;
                return s.isEmpty() ? Skeleton.err(ErrorType.TYPE_EMPTY) : s;
            }
            return Skeleton.err(ErrorType.TYPE_NOT_STRING, type);
        }
        catch (RuntimeException e) {
            return Skeleton.ex(e);
        }
    }

    private void content(SkeletonNode node, Map<String, ?> map) {
        try {
            Object contentObj = map.get("content");
            if (contentObj == null) {
                return;
            }
            if (!(contentObj instanceof List)) {
                node.content(ErrorType.CONTENT_NOT_ARRAY, null);
                return;
            }
            List contentList = (List)Cast.unsafeCast(contentObj);
            List<SkeletonNode> content = contentList.stream().map(this::node).collect(Collectors.toList());
            node.content(content);
        }
        catch (RuntimeException e) {
            node.content(ErrorType.EXCEPTION, e);
        }
    }

    private void marks(SkeletonNode node, Map<String, ?> map) {
        try {
            Object marksObj = map.get("marks");
            if (marksObj == null) {
                return;
            }
            if (!(marksObj instanceof List)) {
                node.marks(ErrorType.MARKS_NOT_ARRAY, null);
                return;
            }
            List marksList = (List)Cast.unsafeCast(marksObj);
            List<String> markTypes = marksList.stream().map(this::type).collect(Collectors.toList());
            node.marks(markTypes);
        }
        catch (RuntimeException e) {
            node.marks(ErrorType.EXCEPTION, e);
        }
    }

    private void attrs(SkeletonNode node, Map<String, ?> map) {
        try {
            Object attrs = map.get("attrs");
            if (attrs == null) {
                return;
            }
            if (!(attrs instanceof Map)) {
                node.attrs(ErrorType.ATTRS_NOT_OBJECT, null);
                return;
            }
            Map attrsMap = (Map)Cast.unsafeCast(attrs);
            List<String> attrsKeys = List.copyOf(attrsMap.keySet());
            node.attrs(attrsKeys);
        }
        catch (RuntimeException e) {
            node.attrs(ErrorType.EXCEPTION, e);
        }
    }

    private static String ex(Exception e) {
        return Skeleton.err(ErrorType.EXCEPTION, e);
    }

    private static String err(ErrorType errorType) {
        return errorType.name();
    }

    private static String err(ErrorType errorType, @Nullable Object value) {
        return value != null ? errorType.name() + OPEN_CLASS + value.getClass().getSimpleName() + CLOSE_CLASS : Skeleton.err(errorType);
    }

    private static void appendListTo(StringBuilder sb, List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        Iterator<String> it = list.iterator();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(',').append(it.next());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Format {
        COMPACT{

            @Override
            String format(SkeletonNode node) {
                StringBuilder sb = new StringBuilder(4096);
                sb.append(Skeleton.SHORT_SKELETON_PREFIX);
                node.appendCompactTo(sb);
                return sb.toString();
            }
        }
        ,
        PRETTY{

            @Override
            String format(SkeletonNode node) {
                StringBuilder sb = new StringBuilder(4096);
                StringBuilder indent = new StringBuilder();
                node.appendPrettyTo(sb, indent);
                return sb.toString();
            }
        };


        abstract String format(SkeletonNode var1);
    }

    static class SkeletonNode {
        String type;
        @Nullable
        List<SkeletonNode> content;
        @Nullable
        List<String> marks;
        @Nullable
        List<String> attrs;

        SkeletonNode(String type) {
            this.type = type;
        }

        String type() {
            return this.type;
        }

        void content(ErrorType errorType, @Nullable Object value) {
            this.content = List.of(new SkeletonNode(Skeleton.err(errorType, value)));
        }

        void content(List<SkeletonNode> content) {
            this.content = content;
        }

        void marks(ErrorType errorType, @Nullable Object value) {
            this.marks = List.of(Skeleton.err(errorType, value));
        }

        void marks(List<String> marks) {
            this.marks = marks;
        }

        void attrs(ErrorType errorType, @Nullable Object value) {
            this.attrs = List.of(Skeleton.err(errorType, value));
        }

        void attrs(List<String> attrs) {
            this.attrs = attrs;
        }

        void appendCompactTo(StringBuilder sb) {
            sb.append('{');
            sb.append(this.type);
            if (this.marks != null) {
                sb.append('[');
                Skeleton.appendListTo(sb, this.marks);
                sb.append(']');
            }
            if (this.attrs != null) {
                sb.append('<');
                Skeleton.appendListTo(sb, this.attrs);
                sb.append('>');
            }
            if (this.content != null) {
                sb.append(':');
                this.content.forEach(node -> node.appendCompactTo(sb));
            }
            sb.append('}');
        }

        void appendPrettyTo(StringBuilder sb, StringBuilder indent) {
            sb.append((CharSequence)indent).append(this.type);
            if (this.marks != null) {
                sb.append(' ').append('[');
                Skeleton.appendListTo(sb, this.marks);
                sb.append(']');
            }
            if (this.attrs != null) {
                sb.append(' ').append('<');
                Skeleton.appendListTo(sb, this.attrs);
                sb.append('>');
            }
            if (this.content != null) {
                sb.append(' ').append('{');
                if (!this.content.isEmpty()) {
                    sb.append('\n');
                    int savedIndent = indent.length();
                    indent.append(Skeleton.INDENT);
                    this.content.forEach(node -> node.appendPrettyTo(sb, indent));
                    indent.setLength(savedIndent);
                    sb.append((CharSequence)indent);
                }
                sb.append('}');
            }
            sb.append('\n');
        }
    }

    public static enum ErrorType {
        NODE_NOT_OBJECT,
        MARK_NOT_OBJECT,
        TYPE_NULL,
        TYPE_NOT_STRING,
        TYPE_EMPTY,
        CONTENT_NOT_ARRAY,
        MARKS_NOT_ARRAY,
        ATTRS_NOT_OBJECT,
        EXCEPTION;

    }
}

