/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model;

import com.atlassian.adf.util.InputStreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Schema {
    private static final String VERSION = "48.0.0";
    private final String filename;
    @Nullable
    private String schema;

    private Schema(String filename) {
        this.filename = filename;
    }

    public static String version() {
        return VERSION;
    }

    public static Full full() {
        return Full.FULL;
    }

    public static Stage0 stage0() {
        return Stage0.STAGE0;
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public static URL url() {
        return Schema.url("full.json");
    }

    private static URL url(String filename) {
        URL url = Schema.class.getClassLoader().getResource(filename);
        if (url == null) {
            throw new IllegalStateException("Unable to load schema: " + filename + ": File not found");
        }
        return url;
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public static InputStream inputStream() throws IOException {
        return Schema.url("full.json").openStream();
    }

    public static String schema() {
        return Schema.full().toString();
    }

    public String filename() {
        return this.filename;
    }

    public String toString() {
        String cached = this.schema;
        if (cached == null) {
            try (InputStream is = Schema.url(this.filename).openStream();){
                this.schema = cached = InputStreamUtil.readUtf8(is);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Unable to load schema: " + String.valueOf(ioe), ioe);
            }
        }
        return cached;
    }

    public static final class Full
    extends Schema {
        public static final String FILENAME = "full.json";
        public static final Full FULL = new Full();

        private Full() {
            super(FILENAME);
        }
    }

    public static final class Stage0
    extends Schema {
        public static final String FILENAME = "stage-0.json";
        public static final Stage0 STAGE0 = new Stage0();

        private Stage0() {
            super(FILENAME);
        }
    }
}

