/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.LocalIdOptional;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.REVIEWED, date="2024-11-11")
public class Placeholder
extends AbstractNode<Placeholder>
implements LocalIdOptional<Placeholder>,
CaptionContent,
InlineContent {
    static final Factory<Placeholder> FACTORY = new Factory<Placeholder>("placeholder", Placeholder.class, Placeholder::parse);
    @Nullable
    private String localId;
    private String text;

    private Placeholder(String text) {
        this.text = Placeholder.validateText(text);
    }

    public Partial.NeedsText placeholder() {
        return new Partial.NeedsText();
    }

    public static Placeholder placeholder(String text) {
        return new Placeholder(text);
    }

    @Override
    public Placeholder localId(@Nullable String localId) {
        this.localId = localId;
        return this;
    }

    @Override
    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    public Placeholder text(String text) {
        this.text = Placeholder.validateText(text);
        return this;
    }

    public String text() {
        return this.text;
    }

    @Override
    public Placeholder copy() {
        return Placeholder.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "placeholder";
    }

    @Override
    public void validate() {
    }

    @Override
    protected int nodeHashCode() {
        return Objects.hash(this.text, this.localId);
    }

    @Override
    protected boolean nodeEquals(Placeholder other) {
        return this.text.equals(other.text) && Objects.equals(this.localId, other.localId);
    }

    @Override
    protected void appendNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("localId", this.localId);
        buf.appendTextField(this.text);
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map().addIfPresent("localId", this.localId).add("text", this.text));
    }

    private static Placeholder parse(Map<String, ?> map) {
        String text = (String)ParserSupport.getAttrOrThrow(map, "text");
        Placeholder placeholder = new Placeholder(text);
        LocalIdOptional.parseLocalId(placeholder, map);
        return placeholder;
    }

    private static String validateText(String text) {
        return Element.nonEmpty(text, "text");
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        sb.append(this.text);
    }

    public static interface Partial {

        public static class NeedsText {
            NeedsText() {
            }

            public Placeholder text(String text) {
                return new Placeholder(text);
            }
        }
    }
}

