/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.type.MultiBodiedExtensionMark;
import com.atlassian.adf.model.node.AbstractMarkedContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.ExtensionSettings;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.ExtensionNode;
import com.atlassian.adf.model.node.type.MultiBodiedExtensionContent;
import com.atlassian.adf.model.node.unsupported.UnsupportedNode;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import com.atlassian.annotations.ExperimentalApi;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@ExperimentalApi
public class MultiBodiedExtension
extends AbstractMarkedContentNode<MultiBodiedExtension, MultiBodiedExtensionContent, MultiBodiedExtensionMark>
implements ExtensionNode<MultiBodiedExtension, MultiBodiedExtensionMark>,
DocContent {
    static final Factory<MultiBodiedExtension> FACTORY = new Factory<MultiBodiedExtension>("multiBodiedExtension", MultiBodiedExtension.class, MultiBodiedExtension::parse);
    private final ExtensionSettings settings;
    @Nullable
    private ExtensionSettings.Layout layout;

    private MultiBodiedExtension(ExtensionSettings settings) {
        this.settings = settings;
    }

    @CheckReturnValue
    public static ExtensionSettings.Partial.NeedsExtensionKey<MultiBodiedExtension> multiBodiedExtension() {
        return new ExtensionSettings.Partial.NeedsExtensionKey<MultiBodiedExtension>(MultiBodiedExtension::new);
    }

    public static MultiBodiedExtension multiBodiedExtension(String extensionKey, String extensionType) {
        return ExtensionSettings.extensionSettings(MultiBodiedExtension::new).extensionKey(extensionKey).extensionType(extensionType);
    }

    @Override
    public Class<MultiBodiedExtensionContent> contentClass() {
        return MultiBodiedExtensionContent.class;
    }

    @Override
    public MultiBodiedExtension copy() {
        return MultiBodiedExtension.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "multiBodiedExtension";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", this.settings.toExtensionAttrs().addMappedIfPresent("layout", this.layout, ExtensionSettings.Layout::layout)).let(this::addContent).let(this.marks::addToMap);
    }

    @Override
    public Class<MultiBodiedExtensionMark> markClass() {
        return MultiBodiedExtensionMark.class;
    }

    @Override
    protected void markedContentNodeValidate() {
        this.requireNotEmpty();
    }

    @Override
    protected int markedContentNodeHashCode() {
        return Objects.hash(new Object[]{this.layout, this.settings});
    }

    @Override
    protected boolean markedContentNodeEquals(MultiBodiedExtension other) {
        return this.layout == other.layout && this.settings.equals(other.settings);
    }

    @Override
    protected void appendMarkedContentNodeFields(AbstractNode.ToStringHelper buf) {
        this.settings.appendExtensionFields(buf);
        buf.appendField("layout", (Object)this.layout);
    }

    @Override
    public String extensionKey() {
        return this.settings.extensionKey();
    }

    @Override
    public MultiBodiedExtension extensionKey(String extensionKey) {
        this.settings.extensionKey(extensionKey);
        return this;
    }

    @Override
    public String extensionType() {
        return this.settings.extensionType();
    }

    @Override
    public MultiBodiedExtension extensionType(String extensionType) {
        this.settings.extensionType(extensionType);
        return this;
    }

    @Override
    public MultiBodiedExtension localId(@Nullable String localId) {
        this.settings.localId(localId);
        return this;
    }

    @Override
    public Optional<String> localId() {
        return this.settings.localId();
    }

    @Override
    public MultiBodiedExtension text(@Nullable String text) {
        this.settings.text(text);
        return this;
    }

    @Override
    public Optional<String> text() {
        return this.settings.text();
    }

    @Override
    public MultiBodiedExtension parameters(@Nullable Map<String, ?> parameters) {
        this.settings.parameters(parameters);
        return this;
    }

    @Override
    public Optional<Map<String, ?>> parameters() {
        return this.settings.parameters();
    }

    public MultiBodiedExtension layout(String layout) {
        return this.layout(ExtensionSettings.Layout.PARSER.parse(layout));
    }

    public MultiBodiedExtension layout(ExtensionSettings.Layout layout) {
        this.layout = layout;
        return this;
    }

    public Optional<ExtensionSettings.Layout> layout() {
        return Optional.ofNullable(this.layout);
    }

    private static MultiBodiedExtension parse(Map<String, ?> map) {
        ExtensionSettings settings = ExtensionSettings.parse(map);
        MultiBodiedExtension extension = (MultiBodiedExtension)new MultiBodiedExtension(settings).parseRequiredContentAllowEmpty(map, MultiBodiedExtensionContent.class);
        ParserSupport.getAttr(map, "layout", String.class).ifPresent(layout -> extension.layout(ExtensionSettings.Layout.PARSER.parse((String)layout)));
        return (MultiBodiedExtension)extension.parseMarks(map);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        String text = this.settings.text().orElseGet(() -> UnsupportedNode.plainTextFallback(this));
        sb.append(text);
    }
}

