/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.LocalIdRequired;
import com.atlassian.adf.model.mark.Breakout;
import com.atlassian.adf.model.mark.type.BodiedSyncBlockMark;
import com.atlassian.adf.model.node.AbstractMarkedContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.BodiedSyncBlockContent;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class BodiedSyncBlock
extends AbstractMarkedContentNode<BodiedSyncBlock, BodiedSyncBlockContent, BodiedSyncBlockMark>
implements LocalIdRequired<BodiedSyncBlock>,
DocContent {
    static final Factory<BodiedSyncBlock> FACTORY = new Factory<BodiedSyncBlock>("bodiedSyncBlock", BodiedSyncBlock.class, BodiedSyncBlock::parse);
    private String localId;
    private String resourceId;

    private BodiedSyncBlock(String localId, String resourceId) {
        this.localId = Objects.requireNonNull(localId, "localId");
        this.resourceId = Objects.requireNonNull(resourceId, "resourceId");
    }

    public static Partial.NeedsLocalIdAndResourceId bodiedSyncBlock() {
        return new Partial.NeedsLocalIdAndResourceId();
    }

    @Override
    public String localId() {
        return this.localId;
    }

    @Override
    public BodiedSyncBlock localId(String localId) {
        this.localId = Objects.requireNonNull(localId, "localId");
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public BodiedSyncBlock resourceId(String resourceId) {
        this.resourceId = Objects.requireNonNull(resourceId, "resourceId");
        return this;
    }

    @Override
    public Class<BodiedSyncBlockContent> contentClass() {
        return BodiedSyncBlockContent.class;
    }

    @Override
    public BodiedSyncBlock copy() {
        return BodiedSyncBlock.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "bodiedSyncBlock";
    }

    private static BodiedSyncBlock parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "bodiedSyncBlock");
        String localId = ParserSupport.getAttrOrThrow(map, "localId", String.class);
        String resourceId = ParserSupport.getAttrOrThrow(map, "resourceId", String.class);
        BodiedSyncBlock bodiedSyncBlock = (BodiedSyncBlock)new BodiedSyncBlock(localId, resourceId).parseRequiredContent(map, BodiedSyncBlockContent.class);
        return (BodiedSyncBlock)bodiedSyncBlock.parseMarks(map);
    }

    @Override
    public Class<BodiedSyncBlockMark> markClass() {
        return BodiedSyncBlockMark.class;
    }

    @Override
    protected boolean markedContentNodeEquals(BodiedSyncBlock other) {
        return Objects.equals(this.localId, other.localId) && Objects.equals(this.resourceId, other.resourceId);
    }

    @Override
    protected int markedContentNodeHashCode() {
        return Objects.hash(this.localId, this.resourceId);
    }

    @Override
    protected void appendMarkedContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("localId", this.localId);
        buf.appendField("resourceId", this.resourceId);
    }

    @Override
    protected void markedContentNodeValidate() {
        this.requireNotEmpty();
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().add("attrs", FieldMap.map("localId", this.localId).add("resourceId", this.resourceId)).let(this::addContent).let(this.marks::addToMap);
    }

    public Optional<Breakout> breakout() {
        return this.marks.stream(Breakout.class).findAny();
    }

    public BodiedSyncBlock breakout(@Nullable Breakout breakout) {
        this.marks.clear();
        if (breakout != null) {
            this.marks.add(breakout);
        }
        return this;
    }

    public BodiedSyncBlock wide() {
        return this.breakout(Breakout.wide());
    }

    public BodiedSyncBlock fullWidth() {
        return this.breakout(Breakout.fullWidth());
    }

    public BodiedSyncBlock defaultWidth() {
        return this.breakout(null);
    }

    public static interface Partial {

        public static class NeedsLocalIdAndResourceId {
            NeedsLocalIdAndResourceId() {
            }

            public NeedsResourceId localId(String localId) {
                return new NeedsResourceId(localId);
            }

            public NeedsLocalId resourceId(String resourceId) {
                return new NeedsLocalId(resourceId);
            }
        }

        public static class NeedsLocalId {
            private final String resourceId;

            NeedsLocalId(String resourceId) {
                this.resourceId = Objects.requireNonNull(resourceId, "resourceId");
            }

            public BodiedSyncBlock localId(String localId) {
                return new BodiedSyncBlock(Objects.requireNonNull(localId, "localId"), this.resourceId);
            }
        }

        public static class NeedsResourceId {
            private final String localId;

            NeedsResourceId(String localId) {
                this.localId = Objects.requireNonNull(localId, "localId");
            }

            public BodiedSyncBlock resourceId(String resourceId) {
                return new BodiedSyncBlock(this.localId, Objects.requireNonNull(resourceId, "resourceId"));
            }
        }
    }
}

