/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.Mark;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.MarkHolder;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.Factory;
import com.atlassian.annotations.Internal;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Internal
public abstract class AbstractMarkedNode<N extends AbstractMarkedNode<N, M>, M extends Mark>
extends AbstractNode<N>
implements Marked<N, M> {
    final MarkHolder<M> marks = Objects.requireNonNull(this.createMarkHolder(), "createMarkHolder()");

    AbstractMarkedNode() {
    }

    @Override
    public final void validate() {
        this.marks.validate();
        this.markedNodeValidate();
    }

    protected void markedNodeValidate() {
    }

    @Override
    public abstract N copy();

    @Override
    public abstract Class<M> markClass();

    MarkHolder<M> createMarkHolder() {
        return MarkHolder.unlimited();
    }

    @Override
    public final boolean clearMarks() {
        return this.marks.clear();
    }

    @Override
    public final Collection<M> marks() {
        return this.marks.get();
    }

    @Override
    public final Set<String> markTypes() {
        return this.marks.getTypes();
    }

    @Override
    public final <T extends M> Stream<? extends T> marks(Class<T> markClass) {
        return this.marks.stream(markClass);
    }

    @Override
    public Optional<M> mark(MarkKey markKey) {
        return this.marks.get(markKey);
    }

    @Override
    @Deprecated
    public final Optional<M> mark(String type) {
        return this.marks.findFirst(type);
    }

    @Override
    public N mark(M mark) {
        this.marks.add(mark);
        return (N)((AbstractMarkedNode)Cast.unsafeCast(this));
    }

    @Override
    public boolean markIfAllowed(M mark) {
        return this.marks.addIfAllowed(mark).isEmpty();
    }

    protected N parseMarks(Map<String, ?> map) {
        MarkParserSupport.parseMarks(map, this.markClass(), this.unsupportedMarkFactory(), this);
        return (N)((AbstractMarkedNode)Cast.unsafeCast(this));
    }

    @Nullable
    protected Factory<M> unsupportedMarkFactory() {
        return null;
    }

    protected int markedNodeHashCode() {
        return 0;
    }

    protected boolean markedNodeEquals(N other) {
        return true;
    }

    protected void appendMarkedNodeFields(AbstractNode.ToStringHelper buf) {
    }

    @Override
    protected final int nodeHashCode() {
        return this.markedNodeHashCode() * 31 + this.marks.hashCode();
    }

    @Override
    protected final boolean nodeEquals(N other) {
        return this.markedNodeEquals(other) && this.marks.equals(((AbstractMarkedNode)other).marks);
    }

    @Override
    protected final void appendNodeFields(AbstractNode.ToStringHelper buf) {
        this.appendMarkedNodeFields(buf);
        buf.appendMarksField(this.marks);
    }
}

