/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.ex.node.LayoutColumnException;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.Expand;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class LayoutColumn
extends AbstractContentNode<LayoutColumn, LayoutColumnContent> {
    static final Factory<LayoutColumn> FACTORY = new Factory<LayoutColumn>("layoutColumn", LayoutColumn.class, LayoutColumn::parse);
    private Number width;

    private LayoutColumn(Number width) {
        this.width = LayoutColumn.validateWidth(width);
    }

    public static LayoutColumn layoutColumn(Number width) {
        return new LayoutColumn(width);
    }

    public LayoutColumn width(Number width) {
        this.width = LayoutColumn.validateWidth(width);
        return this;
    }

    public Number width() {
        return this.width;
    }

    @Override
    public LayoutColumn copy() {
        return LayoutColumn.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "layoutColumn";
    }

    @Override
    protected void contentNodeValidate() {
        this.requireNotEmpty();
    }

    @Override
    protected void validateContentNodeForAppend(LayoutColumnContent node) {
        if (node instanceof CodeBlock) {
            ((CodeBlock)node).disableMarks(this);
        } else if (node instanceof Expand) {
            ((Expand)node).disableMarks(this);
        }
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().add("attrs", FieldMap.map().add("width", this.width)).let(this::addContent);
    }

    private static LayoutColumn parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "layoutColumn");
        Number width = ParserSupport.getAttrNumberOrThrow(map, "width");
        return (LayoutColumn)new LayoutColumn(width).parseRequiredContent(map, LayoutColumnContent.class);
    }

    private static Number validateWidth(Number width) {
        Objects.requireNonNull(width, "width");
        double widthAsDouble = width.doubleValue();
        if (widthAsDouble < 0.0 || widthAsDouble > 100.0) {
            throw new LayoutColumnException.InvalidWidth(width);
        }
        return width;
    }
}

